/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.fasterxml.jackson.annotation.JsonRawValue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.util.JsonUtil;
import org.eclipse.jetty.util.ConcurrentHashSet;

public class JsonGraph {
    private static final int INIT_VERTEX_CAPACITY = 1000000;
    private Map<String, Map<Object, JsonVertex>> tables = new ConcurrentHashMap<String, Map<Object, JsonVertex>>();

    public Set<String> tables() {
        return this.tables.keySet();
    }

    public void put(Vertex vertex) {
        Map<Object, JsonVertex> vertices = this.table(vertex.label());
        vertices.put(vertex.id(), JsonVertex.from(vertex));
    }

    public void put(Edge edge) {
        Map<Object, JsonVertex> vertices = this.table(edge.sourceLabel());
        assert (vertices != null);
        JsonVertex source = vertices.get(edge.sourceId());
        if (source == null) {
            return;
        }
        vertices = this.table(edge.targetLabel());
        assert (vertices != null);
        JsonVertex target = vertices.get(edge.targetId());
        if (target == null) {
            return;
        }
        JsonEdge jsonEdge = JsonEdge.from(edge);
        source.addEdge(jsonEdge);
        target.addEdge(jsonEdge);
    }

    public Map<Object, JsonVertex> table(String table) {
        Map<Object, JsonVertex> vertices = this.tables.get(table);
        if (vertices == null) {
            vertices = new ConcurrentHashMap<Object, JsonVertex>(1000000);
            this.tables.putIfAbsent(table, vertices);
        }
        return this.tables.get(table);
    }

    public static class JsonEdge {
        private String id;
        private String label;
        private Object source;
        private Object target;
        private String properties;

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getTarget() {
            return this.target;
        }

        @JsonRawValue
        public String getProperties() {
            return this.properties;
        }

        public Map<String, Object> properties() {
            return (Map)JsonUtil.fromJson((String)this.properties, Map.class);
        }

        public static JsonEdge from(Edge e) {
            JsonEdge edge = new JsonEdge();
            edge.id = e.id();
            edge.label = e.label();
            edge.source = e.sourceId();
            edge.target = e.targetId();
            edge.properties = JsonUtil.toJson((Object)e.properties());
            return edge;
        }
    }

    public static class JsonVertex {
        private Object id;
        private String label;
        private String properties;
        private Set<JsonEdge> edges = new ConcurrentHashSet();

        public void addEdge(JsonEdge edge) {
            this.edges.add(edge);
        }

        public Object getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        @JsonRawValue
        public String getProperties() {
            return this.properties;
        }

        public Set<JsonEdge> getEdges() {
            return this.edges;
        }

        public Map<String, Object> properties() {
            return (Map)JsonUtil.fromJson((String)this.properties, Map.class);
        }

        public static JsonVertex from(Vertex v) {
            JsonVertex vertex = new JsonVertex();
            vertex.id = v.id();
            vertex.label = v.label();
            vertex.properties = JsonUtil.toJson((Object)v.properties());
            return vertex;
        }
    }
}

