/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni.ast;

import org.apache.hadoop.hbase.shaded.org.joni.ScanEnvironment;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StateNode;
import org.apache.hadoop.hbase.shaded.org.joni.exception.ValueException;

public final class BackRefNode
extends StateNode {
    public int backNum;
    public int[] back;
    public int nestLevel;

    public BackRefNode(int backNum, int[] backRefs, boolean byName, ScanEnvironment env) {
        this.backNum = backNum;
        if (byName) {
            this.setNameRef();
        }
        for (int i = 0; i < backNum; ++i) {
            if (backRefs[i] > env.numMem || env.memNodes[backRefs[i]] != null) continue;
            this.setRecursion();
            break;
        }
        this.back = new int[backNum];
        System.arraycopy(backRefs, 0, this.back, 0, backNum);
    }

    public BackRefNode(int backNum, int[] backRefs, boolean byName, boolean existLevel, int nestLevel, ScanEnvironment env) {
        this(backNum, backRefs, byName, env);
        if (existLevel) {
            this.setNestLevel();
            this.nestLevel = nestLevel;
        }
    }

    public int getType() {
        return 4;
    }

    public String getName() {
        return "Back Ref";
    }

    public String toString(int level) {
        StringBuilder value = new StringBuilder(super.toString(level));
        value.append("\n  backNum: " + this.backNum);
        String backs = "";
        for (int i = 0; i < this.back.length; ++i) {
            backs = backs + this.back[i] + ", ";
        }
        value.append("\n  back: " + backs);
        value.append("\n  nextLevel: " + this.nestLevel);
        return value.toString();
    }

    public void renumber(int[] map) {
        if (!this.isNameRef()) {
            throw new ValueException("numbered backref/call is not allowed. (use name)");
        }
        int oldNum = this.backNum;
        int pos = 0;
        for (int i = 0; i < oldNum; ++i) {
            int n = map[this.back[i]];
            if (n <= 0) continue;
            this.back[pos] = n;
            ++pos;
        }
        this.backNum = pos;
    }
}

