/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.util.DataChecksum;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ChecksumUtil {
    public static final Logger LOG = LoggerFactory.getLogger(ChecksumUtil.class);
    private static byte[] DUMMY_VALUE = new byte[512];
    private static boolean generateExceptions = false;

    static void generateChecksums(byte[] indata, int startOffset, int endOffset, byte[] outdata, int outOffset, ChecksumType checksumType, int bytesPerChecksum) throws IOException {
        if (checksumType == ChecksumType.NULL) {
            return;
        }
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)checksumType.getDataChecksumType(), (int)bytesPerChecksum);
        checksum.calculateChunkedSums(ByteBuffer.wrap(indata, startOffset, endOffset - startOffset), ByteBuffer.wrap(outdata, outOffset, outdata.length - outOffset));
    }

    static boolean validateChecksum(ByteBuffer buffer, String pathName, long offset, int hdrSize) throws IOException {
        ChecksumType cktype = ChecksumType.codeToType((byte)buffer.get(HFileBlock.Header.CHECKSUM_TYPE_INDEX));
        if (cktype == ChecksumType.NULL) {
            return true;
        }
        int bytesPerChecksum = buffer.getInt(HFileBlock.Header.BYTES_PER_CHECKSUM_INDEX);
        DataChecksum dataChecksum = DataChecksum.newDataChecksum((DataChecksum.Type)cktype.getDataChecksumType(), (int)bytesPerChecksum);
        assert (dataChecksum != null);
        int onDiskDataSizeWithHeader = buffer.getInt(HFileBlock.Header.ON_DISK_DATA_SIZE_WITH_HEADER_INDEX);
        if (LOG.isTraceEnabled()) {
            LOG.info("dataLength=" + buffer.capacity() + ", sizeWithHeader=" + onDiskDataSizeWithHeader + ", checksumType=" + cktype.getName() + ", file=" + pathName + ", offset=" + offset + ", headerSize=" + hdrSize + ", bytesPerChecksum=" + bytesPerChecksum);
        }
        try {
            ByteBuffer data = (ByteBuffer)buffer.duplicate().position(0).limit(onDiskDataSizeWithHeader);
            ByteBuffer checksums = (ByteBuffer)buffer.duplicate().position(onDiskDataSizeWithHeader).limit(buffer.capacity());
            dataChecksum.verifyChunkedSums(data, checksums, pathName, 0L);
        }
        catch (ChecksumException e) {
            return false;
        }
        return true;
    }

    static long numBytes(long datasize, int bytesPerChecksum) {
        return ChecksumUtil.numChunks(datasize, bytesPerChecksum) * 4L;
    }

    static long numChunks(long datasize, int bytesPerChecksum) {
        long numChunks = datasize / (long)bytesPerChecksum;
        if (datasize % (long)bytesPerChecksum != 0L) {
            ++numChunks;
        }
        return numChunks;
    }

    static void reserveSpaceForChecksums(ByteArrayOutputStream baos, int numBytes, int bytesPerChecksum) throws IOException {
        long count;
        long numChunks = ChecksumUtil.numChunks(numBytes, bytesPerChecksum);
        for (long bytesLeft = numChunks * 4L; bytesLeft > 0L; bytesLeft -= count) {
            count = Math.min(bytesLeft, (long)DUMMY_VALUE.length);
            baos.write(DUMMY_VALUE, 0, (int)count);
        }
    }

    public static void generateExceptionForChecksumFailureForTest(boolean value) {
        generateExceptions = value;
    }
}

