/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.Arrays;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitNormalizationPlan
implements NormalizationPlan {
    private static final Logger LOG = LoggerFactory.getLogger((String)SplitNormalizationPlan.class.getName());
    private RegionInfo regionInfo;
    private byte[] splitPoint;

    public SplitNormalizationPlan(RegionInfo regionInfo, byte[] splitPoint) {
        this.regionInfo = regionInfo;
        this.splitPoint = splitPoint;
    }

    @Override
    public NormalizationPlan.PlanType getType() {
        return NormalizationPlan.PlanType.SPLIT;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public void setRegionInfo(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    public byte[] getSplitPoint() {
        return this.splitPoint;
    }

    public void setSplitPoint(byte[] splitPoint) {
        this.splitPoint = splitPoint;
    }

    public String toString() {
        return "SplitNormalizationPlan{regionInfo=" + this.regionInfo + ", splitPoint=" + Arrays.toString(this.splitPoint) + '}';
    }

    @Override
    public void execute(Admin admin) {
        LOG.info("Executing splitting normalization plan: " + this);
        try {
            admin.splitRegionAsync(this.regionInfo.getRegionName()).get();
        }
        catch (Exception ex) {
            LOG.error("Error during region split: ", (Throwable)ex);
        }
    }
}

