/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.instantiator;

import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Map;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.getter.ConstantIntGetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.BiFunction;

public class KotlinDefaultConstructorInstantiatorDefinition
implements InstantiatorDefinition {
    private final ExecutableInstantiatorDefinition original;
    private final ExecutableInstantiatorDefinition defaulted;

    public KotlinDefaultConstructorInstantiatorDefinition(ExecutableInstantiatorDefinition original, ExecutableInstantiatorDefinition defaulted) {
        this.original = original;
        this.defaulted = defaulted;
    }

    public Member getExecutable() {
        return this.original.getExecutable();
    }

    @Override
    public Parameter[] getParameters() {
        return this.original.getParameters();
    }

    @Override
    public boolean hasParam(Parameter param) {
        return this.original.hasParam(param);
    }

    @Override
    public InstantiatorDefinition.Type getType() {
        return this.original.getType();
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    public String toString() {
        return this.original.toString();
    }

    public InstantiatorDefinition getDefaultValueConstructor() {
        Parameter[] defaultedParameters = this.defaulted.getParameters();
        Parameter[] originalParameters = this.original.getParameters();
        Parameter[] mergedParam = Arrays.copyOf(defaultedParameters, defaultedParameters.length);
        System.arraycopy(originalParameters, 0, mergedParam, 0, originalParameters.length);
        return new ExecutableInstantiatorDefinition(this.defaulted.getExecutable(), mergedParam);
    }

    public <S1, S2> void addDefaultValueFlagBi(Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections) {
        int nbParams = this.original.getParameters().length;
        int nbDefaulting = this.defaulted.getParameters().length - nbParams - 1;
        for (int i = 0; i < nbDefaulting; ++i) {
            int startingParam = i * 32;
            int endParam = Math.min(startingParam + 32, nbParams);
            int flag = 0;
            for (int j = startingParam; j < endParam; ++j) {
                if (injections.containsKey(this.original.getParameters()[j])) continue;
                flag |= 1 << j - startingParam;
            }
            final Integer ff = flag;
            injections.put(this.defaulted.getParameters()[nbParams + i], new BiFunction<Object, Object, Integer>(){

                public Integer apply(Object o, Object o2) {
                    return ff;
                }
            });
        }
    }

    public <S> void addDefaultValueFlag(Map<Parameter, Getter<? super S, ?>> injections) {
        int nbParams = this.original.getParameters().length;
        int nbDefaulting = this.defaulted.getParameters().length - nbParams - 1;
        for (int i = 0; i < nbDefaulting; ++i) {
            int startingParam = i * 32;
            int endParam = Math.min(startingParam + 32, nbParams);
            int flag = 0;
            for (int j = startingParam; j < endParam; ++j) {
                if (injections.containsKey(this.original.getParameters()[j])) continue;
                flag |= 1 << j - startingParam;
            }
            injections.put(this.defaulted.getParameters()[nbParams + i], new ConstantIntGetter(flag));
        }
    }
}

