/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;

public class NonMappedPropertyMeta<T, P>
extends PropertyMeta<T, P> {
    private final Type type = Object.class;
    private final Object[] defineProperties;

    public NonMappedPropertyMeta(String name, Type ownerType, ReflectionService reflectService, Object[] defineProperties) {
        super(NonMappedPropertyMeta.cleanUpName(name), ownerType, reflectService);
        this.defineProperties = defineProperties;
    }

    private static String cleanUpName(String name) {
        int i;
        for (i = 0; i < name.length() && DefaultPropertyNameMatcher.isSeparatorChar(name.charAt(i)); ++i) {
        }
        return i > 0 ? name.substring(i) : name;
    }

    @Override
    public PropertyMeta<T, P> withReflectionService(ReflectionService reflectionService) {
        return new NonMappedPropertyMeta<T, P>(this.getName(), this.getOwnerType(), reflectionService, this.defineProperties);
    }

    @Override
    public Setter<? super T, ? super P> getSetter() {
        return NullSetter.NULL_SETTER;
    }

    @Override
    public Getter<? super T, ? extends P> getGetter() {
        return NullGetter.getter();
    }

    @Override
    public Type getPropertyType() {
        return this.type;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public Object[] getDefinedProperties() {
        return this.defineProperties;
    }

    @Override
    public boolean isNonMapped() {
        return true;
    }

    @Override
    public PropertyMeta<T, P> toNonMapped() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "NonMappedPropertyMeta{name=" + this.getName() + '}';
    }
}

