/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
public class CacheConfig {
    private static final int DEFAULT_MAXSIZE = 1000;
    private static final int DEFAULT_TTL = 600;

    @Bean
    @Primary
    public CacheManager caffeineCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        ArrayList<CaffeineCache> caches = new ArrayList<CaffeineCache>();
        for (Caches c : Caches.values()) {
            Cache cache = Caffeine.newBuilder().recordStats().maximumSize((long)c.maxSize()).expireAfterWrite((long)c.ttl(), TimeUnit.SECONDS).build();
            caches.add(new CaffeineCache(c.name(), cache));
        }
        cacheManager.setCaches(caches);
        return cacheManager;
    }

    public static enum Caches {
        GREMLIN_QUERY;

        private int maxSize = 1000;
        private int ttl = 600;

        private Caches() {
        }

        private Caches(int maxSize, int ttl) {
            this.maxSize = maxSize;
            this.ttl = ttl;
        }

        public int maxSize() {
            return this.maxSize;
        }

        public int ttl() {
            return this.ttl;
        }
    }
}

