/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.common.Response;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.controller.BaseController;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.hugegraph.service.GraphConnectionService;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.service.SettingSSLService;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.hugegraph.util.HugeClientUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections"})
public class GraphConnectionController
extends BaseController {
    private static final Logger log = LogManager.getLogger(GraphConnectionController.class);
    private static final Pattern GRAPH_PATTERN = Pattern.compile("^[A-Za-z][A-Za-z0-9_]{0,47}$");
    @Autowired
    private HugeConfig config;
    @Autowired
    private GraphConnectionService connService;
    @Autowired
    private HugeClientPoolService poolService;
    @Autowired
    private SettingSSLService sslService;

    @GetMapping
    public Response list(@RequestParam(name="content", required=false) String content, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize) {
        IPage<GraphConnection> conns = this.connService.list(content, pageNo, pageSize);
        return Response.builder().status(200).data(conns).build();
    }

    @GetMapping(value={"{id}"})
    public GraphConnection get(@PathVariable(value="id") int id) {
        GraphConnection entity = this.connService.get(id);
        if (entity == null) {
            throw new ExternalException("graph-connection.not-exist.id", id);
        }
        if (!this.poolService.containsKey(id)) {
            this.sslService.configSSL(this.config, entity);
            HugeClient client = HugeClientUtil.tryConnect(entity);
            this.poolService.put(entity, client);
        }
        return entity;
    }

    @PostMapping
    public GraphConnection create(@RequestBody GraphConnection newEntity) {
        this.checkParamsValid(newEntity, true);
        this.checkAddressSecurity(newEntity);
        this.checkEntityUnique(newEntity, true);
        newEntity.setTimeout((Integer)this.config.get(HubbleOptions.CLIENT_REQUEST_TIMEOUT));
        this.sslService.configSSL(this.config, newEntity);
        HugeClient client = HugeClientUtil.tryConnect(newEntity);
        newEntity.setCreateTime(HubbleUtil.nowDate());
        this.connService.save(newEntity);
        this.poolService.put(newEntity, client);
        return newEntity;
    }

    @PutMapping(value={"{id}"})
    public GraphConnection update(@PathVariable(value="id") int id, @RequestBody GraphConnection newEntity) {
        this.checkIdSameAsBody(id, newEntity);
        this.checkParamsValid(newEntity, false);
        this.checkAddressSecurity(newEntity);
        GraphConnection oldEntity = this.connService.get(id);
        if (oldEntity == null) {
            throw new ExternalException("graph-connection.not-exist.id", id);
        }
        GraphConnection entity = this.mergeEntity(oldEntity, newEntity);
        this.checkEntityUnique(entity, false);
        this.sslService.configSSL(this.config, entity);
        HugeClient client = HugeClientUtil.tryConnect(entity);
        this.connService.update(entity);
        this.poolService.put(entity, client);
        return entity;
    }

    @DeleteMapping(value={"{id}"})
    public GraphConnection delete(@PathVariable(value="id") int id) {
        GraphConnection oldEntity = this.connService.get(id);
        if (oldEntity == null) {
            throw new ExternalException("graph-connection.not-exist.id", id);
        }
        this.connService.remove(id);
        this.poolService.remove(oldEntity);
        return oldEntity;
    }

    private void checkParamsValid(GraphConnection newEntity, boolean creating) {
        Ex.check(creating, () -> newEntity.getId() == null, "common.param.must-be-null", "id");
        String name = newEntity.getName();
        this.checkParamsNotEmpty("name", name, creating);
        Ex.check(name != null, () -> Constant.COMMON_NAME_PATTERN.matcher(name).matches(), "graph-connection.name.unmatch-regex", new Object[0]);
        String graph = newEntity.getGraph();
        this.checkParamsNotEmpty("graph", graph, creating);
        Ex.check(graph != null, () -> GRAPH_PATTERN.matcher(graph).matches(), "graph-connection.graph.unmatch-regex", new Object[0]);
        String host = newEntity.getHost();
        this.checkParamsNotEmpty("host", host, creating);
        Ex.check(host != null, () -> HubbleUtil.HOST_PATTERN.matcher(host).matches(), "graph-connection.host.unmatch-regex", new Object[0]);
        Integer port = newEntity.getPort();
        Ex.check(creating, () -> port != null, "common.param.cannot-be-null", "port");
        Ex.check(port != null, () -> 0 < port && port <= 65535, "graph-connection.port.must-be-in-range", "[1, 65535]", port);
        Ex.check(StringUtils.isEmpty((CharSequence)newEntity.getUsername()) && StringUtils.isEmpty((CharSequence)newEntity.getPassword()) || !StringUtils.isEmpty((CharSequence)newEntity.getUsername()) && !StringUtils.isEmpty((CharSequence)newEntity.getPassword()), "graph-connection.username-or-password.must-be-same-status", new Object[0]);
        Ex.check(newEntity.getCreateTime() == null, "common.param.must-be-null", "create_time");
    }

    private void checkAddressSecurity(GraphConnection newEntity) {
        List portWhiteList;
        InetAddress address;
        String host = newEntity.getHost();
        Integer port = newEntity.getPort();
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new ExternalException("graph-connection.host.unresolved", new Object[0]);
        }
        String ip = address.getHostAddress();
        log.debug("The host: {}, ip: {}", (Object)address.getHostName(), (Object)ip);
        List ipWhiteList = (List)this.config.get(HubbleOptions.CONNECTION_IP_WHITE_LIST);
        if (!ipWhiteList.contains("*")) {
            Ex.check(ipWhiteList.contains(host) || ipWhiteList.contains(ip), "graph-connection.host.unauthorized", new Object[0]);
        }
        if (!(portWhiteList = (List)this.config.get(HubbleOptions.CONNECTION_PORT_WHITE_LIST)).contains(-1)) {
            Ex.check(portWhiteList.contains(port), "graph-connection.port.unauthorized", new Object[0]);
        }
    }

    private void checkEntityUnique(GraphConnection newEntity, boolean creating) {
        List<GraphConnection> oldEntities = this.connService.listAll();
        for (GraphConnection oldEntity : oldEntities) {
            if (!creating && oldEntity.getId().equals(newEntity.getId())) continue;
            Ex.check(!oldEntity.getName().equals(newEntity.getName()), "graph-connection.exist.name", oldEntity.getName());
            Ex.check(!oldEntity.getGraph().equals(newEntity.getGraph()) || !oldEntity.getHost().equals(newEntity.getHost()) || !oldEntity.getPort().equals(newEntity.getPort()), "graph-connection.exist.graph-host-port", oldEntity.getGraph(), oldEntity.getHost(), oldEntity.getPort());
        }
    }
}

