/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.load;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.entity.enums.FileMappingStatus;
import org.apache.hugegraph.entity.enums.JobStatus;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.entity.load.FileUploadResult;
import org.apache.hugegraph.entity.load.JobManager;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.hugegraph.service.load.FileMappingService;
import org.apache.hugegraph.service.load.JobManagerService;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.FileUtil;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/job-manager/{jobId}/upload-file"})
public class FileUploadController {
    private static final Logger log = LogManager.getLogger(FileUploadController.class);
    @Autowired
    private HugeConfig config;
    @Autowired
    private FileMappingService service;
    @Autowired
    private JobManagerService jobService;

    @GetMapping(value={"token"})
    public Map<String, String> fileToken(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="names") List<String> fileNames) {
        Ex.check(CollectionUtil.allUnique(fileNames), "load.upload.file.duplicate-name", new Object[0]);
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (String fileName : fileNames) {
            String token = this.service.generateFileToken(fileName);
            Ex.check(!this.uploadingTokenLocks().containsKey(token), "load.upload.file.token.existed", new Object[0]);
            this.uploadingTokenLocks().put(token, new ReentrantReadWriteLock());
            tokens.put(fileName, token);
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping
    public FileUploadResult upload(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="file") MultipartFile file, @RequestParam(value="name") String fileName, @RequestParam(value="token") String token, @RequestParam(value="total") int total, @RequestParam(value="index") int index) {
        FileMapping mapping;
        this.checkTotalAndIndexValid(total, index);
        this.checkFileNameMatchToken(fileName, token);
        JobManager jobEntity = this.jobService.get(jobId);
        this.checkFileValid(connId, jobId, jobEntity, file, fileName);
        if (jobEntity.getJobStatus() == JobStatus.DEFAULT) {
            jobEntity.setJobStatus(JobStatus.UPLOADING);
            this.jobService.update(jobEntity);
        }
        String filePath = this.generateFilePath(connId, jobId, fileName);
        ReadWriteLock lock = this.uploadingTokenLocks().get(token);
        if (lock == null) {
            FileUploadResult result = new FileUploadResult();
            result.setName(file.getOriginalFilename());
            result.setSize(file.getSize());
            result.setStatus(FileUploadResult.Status.FAILURE);
            result.setCause("File has been deleted");
            return result;
        }
        lock.readLock().lock();
        FileUploadResult result = this.service.uploadFile(file, index, filePath);
        if (result.getStatus() == FileUploadResult.Status.FAILURE) {
            FileUploadResult fileUploadResult = result;
            lock.readLock().unlock();
            return fileUploadResult;
        }
        Object object = this.service;
        synchronized (object) {
            mapping = this.service.get(connId, jobId, fileName);
            if (mapping == null) {
                mapping = new FileMapping(connId, fileName, filePath);
                mapping.setJobId(jobId);
                mapping.setFileStatus(FileMappingStatus.UPLOADING);
                this.service.save(mapping);
                break block15;
            }
            if (mapping.getFileStatus() == FileMappingStatus.COMPLETED) {
                result.setId(mapping.getId());
                this.uploadingTokenLocks().remove(token);
                FileUploadResult fileUploadResult = result;
                // MONITOREXIT @DISABLED, blocks:[0, 6, 10] lbl41 : MonitorExitStatement: MONITOREXIT : var12_14
                lock.readLock().unlock();
                return fileUploadResult;
            }
            mapping.setUpdateTime(HubbleUtil.nowDate());
        }
        {
            block15: {
            }
            boolean merged = this.service.tryMergePartFiles(filePath, total);
            if (!merged) {
                this.service.update(mapping);
                FileUploadResult fileUploadResult = result;
                // MONITOREXIT @DISABLED, blocks:[6, 9] lbl50 : MonitorExitStatement: MONITOREXIT : var12_14
                lock.readLock().unlock();
                return fileUploadResult;
            }
            try {
                this.service.extractColumns(mapping);
                mapping.setFileStatus(FileMappingStatus.COMPLETED);
                mapping.setTotalLines(FileUtil.countLines(mapping.getPath()));
                mapping.setTotalSize(FileUtils.sizeOf((File)new File(mapping.getPath())));
                String newPath = this.service.moveToNextLevelDir(mapping);
                mapping.setPath(newPath);
                this.service.update(mapping);
                long jobSize = jobEntity.getJobSize() + mapping.getTotalSize();
                jobEntity.setJobSize(jobSize);
                this.jobService.update(jobEntity);
                result.setId(mapping.getId());
                this.uploadingTokenLocks().remove(token);
                // MONITOREXIT @DISABLED, blocks:[4, 6] lbl72 : MonitorExitStatement: MONITOREXIT : var12_14
                object = result;
                return object;
            }
            finally {
                lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteMapping
    public Boolean delete(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="name") String fileName, @RequestParam(value="token") String token) {
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.UPLOADING || jobEntity.getJobStatus() == JobStatus.MAPPING || jobEntity.getJobStatus() == JobStatus.SETTING, "deleted.file.no-permission", new Object[0]);
        FileMapping mapping = this.service.get(connId, jobId, fileName);
        Ex.check(mapping != null, "load.file-mapping.not-exist.name", fileName);
        ReadWriteLock lock = this.uploadingTokenLocks().get(token);
        if (lock != null) {
            lock.writeLock().lock();
        }
        try {
            this.service.deleteDiskFile(mapping);
            log.info("Prepare to remove file mapping {}", (Object)mapping.getId());
            this.service.remove(mapping.getId());
            long jobSize = jobEntity.getJobSize() - mapping.getTotalSize();
            jobEntity.setJobSize(jobSize);
            this.jobService.update(jobEntity);
            if (lock != null) {
                this.uploadingTokenLocks().remove(token);
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.writeLock().unlock();
            }
        }
    }

    @PutMapping(value={"next-step"})
    public JobManager nextStep(@PathVariable(value="jobId") int jobId) {
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.UPLOADING, "job.manager.status.unexpected", new Object[]{JobStatus.UPLOADING, jobEntity.getJobStatus()});
        jobEntity.setJobStatus(JobStatus.MAPPING);
        this.jobService.update(jobEntity);
        return jobEntity;
    }

    private Map<String, ReadWriteLock> uploadingTokenLocks() {
        return this.service.getUploadingTokenLocks();
    }

    private void checkTotalAndIndexValid(int total, int index) {
        if (total <= 0) {
            throw new InternalException("The request params 'total' must > 0", new Object[0]);
        }
        if (index < 0) {
            throw new InternalException("The request params 'index' must >= 0", new Object[0]);
        }
    }

    private void checkFileNameMatchToken(String fileName, String token) {
        String md5Prefix = HubbleUtil.md5(fileName);
        Ex.check(StringUtils.isNotEmpty((String)token) && token.startsWith(md5Prefix), "load.upload.file.name-token.unmatch", new Object[0]);
    }

    private void checkFileValid(int connId, int jobId, JobManager jobEntity, MultipartFile file, String fileName) {
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.DEFAULT || jobEntity.getJobStatus() == JobStatus.UPLOADING || jobEntity.getJobStatus() == JobStatus.MAPPING || jobEntity.getJobStatus() == JobStatus.SETTING, "load.upload.file.no-permission", new Object[0]);
        Ex.check(!file.isEmpty(), "load.upload.file.cannot-be-empty", new Object[0]);
        log.debug("File content type: {}", (Object)file.getContentType());
        String format = FilenameUtils.getExtension((String)fileName);
        List formatWhiteList = (List)this.config.get(HubbleOptions.UPLOAD_FILE_FORMAT_LIST);
        Ex.check(formatWhiteList.contains(format), "load.upload.file.format.unsupported", new Object[0]);
        long fileSize = file.getSize();
        long singleFileSizeLimit = (Long)this.config.get(HubbleOptions.UPLOAD_SINGLE_FILE_SIZE_LIMIT);
        Ex.check(fileSize <= singleFileSizeLimit, "load.upload.file.exceed-single-size", FileUtils.byteCountToDisplaySize((long)singleFileSizeLimit));
        FileMapping oldMapping = this.service.get(connId, jobId, fileName);
        Ex.check(oldMapping == null || oldMapping.getFileStatus() == FileMappingStatus.UPLOADING, "load.upload.file.existed", fileName);
        long totalFileSizeLimit = (Long)this.config.get(HubbleOptions.UPLOAD_TOTAL_FILE_SIZE_LIMIT);
        List<FileMapping> fileMappings = this.service.listAll();
        long currentTotalSize = fileMappings.stream().map(FileMapping::getTotalSize).reduce(0L, Long::sum);
        Ex.check(fileSize + currentTotalSize <= totalFileSizeLimit, "load.upload.file.exceed-single-size", FileUtils.byteCountToDisplaySize((long)totalFileSizeLimit));
    }

    private String generateFilePath(int connId, int jobId, String fileName) {
        String location = (String)this.config.get(HubbleOptions.UPLOAD_FILE_LOCATION);
        String path = Paths.get("graph-connection-" + connId, "job-" + jobId).toString();
        this.ensureLocationExist(location, path);
        return Paths.get(location, path, fileName).toString();
    }

    private void ensureLocationExist(String location, String connPath) {
        String path = Paths.get(location, connPath).toString();
        File locationDir = new File(path);
        if (!locationDir.exists()) {
            try {
                FileUtils.forceMkdir((File)locationDir);
            }
            catch (IOException e) {
                throw new InternalException("failed to create location dir", (Throwable)e, new Object[0]);
            }
        }
    }
}

