/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.structure.constant.IndexType;
import org.apache.hugegraph.util.HubbleUtil;

public class PropertyIndex
implements SchemaEntity {
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="owner_type")
    private SchemaType ownerType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private IndexType type;
    @JsonProperty(value="fields")
    private List<String> fields;

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.PROPERTY_INDEX;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyIndex)) {
            return false;
        }
        PropertyIndex other = (PropertyIndex)object;
        return this.owner.equals(other.owner) && this.name.equals(other.name) && this.type == other.type && HubbleUtil.equalCollection(this.fields, other.fields);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static PropertyIndexBuilder builder() {
        return new PropertyIndexBuilder();
    }

    public String getOwner() {
        return this.owner;
    }

    public SchemaType getOwnerType() {
        return this.ownerType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IndexType getType() {
        return this.type;
    }

    public List<String> getFields() {
        return this.fields;
    }

    @JsonProperty(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @JsonProperty(value="owner_type")
    public void setOwnerType(SchemaType ownerType) {
        this.ownerType = ownerType;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="type")
    public void setType(IndexType type) {
        this.type = type;
    }

    @JsonProperty(value="fields")
    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String toString() {
        return "PropertyIndex(owner=" + this.getOwner() + ", ownerType=" + (Object)((Object)this.getOwnerType()) + ", name=" + this.getName() + ", type=" + this.getType() + ", fields=" + this.getFields() + ")";
    }

    public PropertyIndex() {
    }

    public PropertyIndex(String owner, SchemaType ownerType, String name, IndexType type, List<String> fields) {
        this.owner = owner;
        this.ownerType = ownerType;
        this.name = name;
        this.type = type;
        this.fields = fields;
    }

    public static class PropertyIndexBuilder {
        private String owner;
        private SchemaType ownerType;
        private String name;
        private IndexType type;
        private List<String> fields;

        PropertyIndexBuilder() {
        }

        @JsonProperty(value="owner")
        public PropertyIndexBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @JsonProperty(value="owner_type")
        public PropertyIndexBuilder ownerType(SchemaType ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        @JsonProperty(value="name")
        public PropertyIndexBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public PropertyIndexBuilder type(IndexType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="fields")
        public PropertyIndexBuilder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PropertyIndex build() {
            return new PropertyIndex(this.owner, this.ownerType, this.name, this.type, this.fields);
        }

        public String toString() {
            return "PropertyIndex.PropertyIndexBuilder(owner=" + this.owner + ", ownerType=" + (Object)((Object)this.ownerType) + ", name=" + this.name + ", type=" + this.type + ", fields=" + this.fields + ")";
        }
    }
}

