/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.options;

import java.util.Collection;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.util.HubbleUtil;
import org.springframework.util.CollectionUtils;

public class HubbleOptions
extends OptionHolder {
    private static volatile HubbleOptions instance;
    public static final ConfigOption<String> SERVER_ID;
    public static final ConfigOption<String> SERVER_HOST;
    public static final ConfigOption<Integer> SERVER_PORT;
    public static final ConfigListOption<String> CONNECTION_IP_WHITE_LIST;
    public static final ConfigListOption<Integer> CONNECTION_PORT_WHITE_LIST;
    public static final ConfigOption<Integer> CLIENT_REQUEST_TIMEOUT;
    public static final ConfigOption<Integer> GREMLIN_SUFFIX_LIMIT;
    public static final ConfigOption<Integer> GREMLIN_VERTEX_DEGREE_LIMIT;
    public static final ConfigOption<Integer> GREMLIN_EDGES_TOTAL_LIMIT;
    public static final ConfigOption<Integer> GREMLIN_BATCH_QUERY_IDS;
    public static final ConfigOption<Integer> EXECUTE_HISTORY_SHOW_LIMIT;
    public static final ConfigOption<String> UPLOAD_FILE_LOCATION;
    public static final ConfigListOption<String> UPLOAD_FILE_FORMAT_LIST;
    public static final ConfigOption<Long> UPLOAD_SINGLE_FILE_SIZE_LIMIT;
    public static final ConfigOption<Long> UPLOAD_TOTAL_FILE_SIZE_LIMIT;
    public static final ConfigOption<Long> UPLOAD_FILE_MAX_TIME_CONSUMING;
    public static final ConfigOption<String> SERVER_PROTOCOL;
    public static final ConfigOption<String> CLIENT_TRUSTSTORE_FILE;
    public static final ConfigOption<String> CLIENT_TRUSTSTORE_PASSWORD;

    private HubbleOptions() {
    }

    public static synchronized HubbleOptions instance() {
        if (instance == null) {
            instance = new HubbleOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        SERVER_ID = new ConfigOption("server.id", "The id of hugegraph-hubble server.", OptionChecker.disallowEmpty(), (Object)"hubble-1");
        SERVER_HOST = new ConfigOption("hubble.host", "The host of hugegraph-hubble server.", OptionChecker.disallowEmpty(), (Object)"localhost");
        SERVER_PORT = new ConfigOption("hubble.port", "The port of hugegraph-hubble server.", OptionChecker.rangeInt((Number)1, (Number)65535), (Object)8088);
        CONNECTION_IP_WHITE_LIST = new ConfigListOption("graph_connection.ip_white_list", "The ip white list available for connecting to HugeGraphServer, * means no ip limited.", input -> {
            if (CollectionUtils.isEmpty((Collection)input)) {
                return false;
            }
            if (input.contains("*") && input.size() > 1) {
                return false;
            }
            for (String ip : input) {
                if (HubbleUtil.HOST_PATTERN.matcher(ip).matches()) continue;
                return false;
            }
            return true;
        }, (Object[])new String[]{"*"});
        CONNECTION_PORT_WHITE_LIST = new ConfigListOption("graph_connection.port_white_list", "The port white list available for connecting to HugeGraphServer, -1 means no port limited.", input -> {
            if (CollectionUtils.isEmpty((Collection)input)) {
                return false;
            }
            return !input.contains(-1) || input.size() <= 1;
        }, (Object[])new Integer[]{-1});
        CLIENT_REQUEST_TIMEOUT = new ConfigOption("client.request_timeout", "The request timeout in seconds for HugeClient.", OptionChecker.positiveInt(), (Object)60);
        GREMLIN_SUFFIX_LIMIT = new ConfigOption("gremlin.suffix_limit", "The limit suffix to be added to gremlin statement.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)250);
        GREMLIN_VERTEX_DEGREE_LIMIT = new ConfigOption("gremlin.vertex_degree_limit", "The max edges count for per vertex.", OptionChecker.rangeInt((Number)1, (Number)500), (Object)100);
        GREMLIN_EDGES_TOTAL_LIMIT = new ConfigOption("gremlin.edges_total_limit", "The edges total limit.", OptionChecker.rangeInt((Number)1, (Number)1000), (Object)500);
        GREMLIN_BATCH_QUERY_IDS = new ConfigOption("gremlin.batch_query_ids", "The ids count for every batch.", OptionChecker.rangeInt((Number)1, (Number)250), (Object)100);
        EXECUTE_HISTORY_SHOW_LIMIT = new ConfigOption("execute-history.show_limit", "The show limit of execute histories.", OptionChecker.rangeInt((Number)0, (Number)10000), (Object)500);
        UPLOAD_FILE_LOCATION = new ConfigOption("upload_file.location", "The location of uploaded files.", OptionChecker.disallowEmpty(), (Object)"upload-files");
        UPLOAD_FILE_FORMAT_LIST = new ConfigListOption("upload_file.format_list", "The format white list available for uploading file.", null, (Object[])new String[]{"csv"});
        UPLOAD_SINGLE_FILE_SIZE_LIMIT = new ConfigOption("upload_file.single_file_size_limit", "The single file size(MB) limit.", OptionChecker.positiveInt(), (Object)0x40000000L);
        UPLOAD_TOTAL_FILE_SIZE_LIMIT = new ConfigOption("upload_file.total_file_size_limit", "The total file size(MB) limit.", OptionChecker.positiveInt(), (Object)0x280000000L);
        UPLOAD_FILE_MAX_TIME_CONSUMING = new ConfigOption("upload_file.max_uploading_time", "The maximum allowable uploading time(second) for file uploads, the uploaded file parts will be cleared if exceed this time", OptionChecker.positiveInt(), (Object)43200L);
        SERVER_PROTOCOL = new ConfigOption("server.protocol", "The protocol of HugeGraphServer, allowed values are: http or https", OptionChecker.allowValues((Object[])new String[]{"http", "https"}), (Object)"http");
        CLIENT_TRUSTSTORE_FILE = new ConfigOption("ssl.client_truststore_file", "The path of the client truststore file when https protocol is enabled", null, (Object)"conf/hugegraph.truststore");
        CLIENT_TRUSTSTORE_PASSWORD = new ConfigOption("ssl.client_truststore_password", "The password of the client truststore when https protocol is enabled", null, (Object)"hugegraph");
    }
}

