/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.time.Instant;
import java.time.temporal.ChronoField;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.enums.AsyncTaskStatus;
import org.apache.hugegraph.entity.enums.ExecuteType;
import org.apache.hugegraph.entity.query.ExecuteHistory;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.mapper.query.ExecuteHistoryMapper;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.structure.Task;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExecuteHistoryService {
    private static final Logger log = LogManager.getLogger(ExecuteHistoryService.class);
    @Autowired
    private HugeConfig config;
    @Autowired
    private ExecuteHistoryMapper mapper;
    @Autowired
    private HugeClientPoolService poolService;

    private HugeClient getClient(int connId) {
        return this.poolService.getOrCreate(connId);
    }

    public IPage<ExecuteHistory> list(int connId, long current, long pageSize) {
        HugeClient client = this.getClient(connId);
        QueryWrapper query = Wrappers.query();
        ((QueryWrapper)query.eq((Object)"conn_id", (Object)connId)).orderByDesc((Object)"create_time");
        Page page = new Page(current, pageSize);
        IPage results = this.mapper.selectPage((IPage)page, (Wrapper)query);
        int limit = (Integer)this.config.get(HubbleOptions.EXECUTE_HISTORY_SHOW_LIMIT);
        if (results.getTotal() > (long)limit) {
            log.debug("Execute history total records: {}", (Object)results.getTotal());
            results.setTotal((long)limit);
        }
        Instant now = HubbleUtil.nowTime();
        results.getRecords().forEach(p -> {
            if (p.getType().equals((Object)ExecuteType.GREMLIN_ASYNC)) {
                try {
                    Task task = client.task().get(p.getAsyncId().longValue());
                    long endDate = task.updateTime() > 0L ? task.updateTime() : now.getLong(ChronoField.INSTANT_SECONDS);
                    p.setDuration(endDate - task.createTime());
                    p.setAsyncStatus(task.status().toUpperCase());
                }
                catch (Exception e) {
                    p.setDuration(0L);
                    p.setAsyncStatus(AsyncTaskStatus.UNKNOWN);
                }
            }
        });
        return results;
    }

    public ExecuteHistory get(int connId, int id) {
        HugeClient client = this.getClient(connId);
        ExecuteHistory history = (ExecuteHistory)this.mapper.selectById(Integer.valueOf(id));
        if (history.getType().equals((Object)ExecuteType.GREMLIN_ASYNC)) {
            try {
                Task task = client.task().get(history.getAsyncId().longValue());
                history.setDuration(task.updateTime() - task.createTime());
                history.setAsyncStatus(task.status().toUpperCase());
            }
            catch (Exception e) {
                history.setDuration(0L);
                history.setAsyncStatus(AsyncTaskStatus.UNKNOWN);
            }
        }
        return history;
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void save(ExecuteHistory history) {
        if (this.mapper.insert(history) != 1) {
            throw new InternalException("entity.insert.failed", history);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(ExecuteHistory history) {
        if (this.mapper.updateById(history) != 1) {
            throw new InternalException("entity.update.failed", history);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(int connId, int id) {
        ExecuteHistory history = (ExecuteHistory)this.mapper.selectById(Integer.valueOf(id));
        HugeClient client = this.getClient(connId);
        if (history.getType().equals((Object)ExecuteType.GREMLIN_ASYNC)) {
            client.task().delete(history.getAsyncId().longValue());
        }
        if (this.mapper.deleteById(Integer.valueOf(id)) != 1) {
            throw new InternalException("entity.delete.failed", history);
        }
    }

    @Async
    @Scheduled(fixedDelay=86400000L)
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void removeExceedLimit() {
        int limit = (Integer)this.config.get(HubbleOptions.EXECUTE_HISTORY_SHOW_LIMIT);
        this.mapper.deleteExceedLimit(limit);
    }
}

