/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.schema.ConflictCheckEntity;
import org.apache.hugegraph.entity.schema.ConflictDetail;
import org.apache.hugegraph.entity.schema.ConflictStatus;
import org.apache.hugegraph.entity.schema.Property;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.SchemaConflict;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.entity.schema.VertexLabelStyle;
import org.apache.hugegraph.entity.schema.VertexLabelUpdateEntity;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.service.schema.PropertyIndexService;
import org.apache.hugegraph.service.schema.PropertyKeyService;
import org.apache.hugegraph.service.schema.SchemaService;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.IndexLabel;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VertexLabelService
extends SchemaService {
    private static final Logger log = LogManager.getLogger(VertexLabelService.class);
    @Autowired
    private PropertyKeyService pkService;
    @Autowired
    private PropertyIndexService piService;

    public List<VertexLabelEntity> list(int connId) {
        return this.list(Collections.emptyList(), connId);
    }

    public List<VertexLabelEntity> list(Collection<String> names, int connId) {
        return this.list(names, connId, true);
    }

    public List<VertexLabelEntity> list(Collection<String> names, int connId, boolean emptyAsAll) {
        HugeClient client = this.client(connId);
        List vertexLabels = CollectionUtils.isEmpty(names) ? (emptyAsAll ? client.schema().getVertexLabels() : new ArrayList()) : client.schema().getVertexLabels(new ArrayList<String>(names));
        List indexLabels = client.schema().getIndexLabels();
        ArrayList<VertexLabelEntity> results = new ArrayList<VertexLabelEntity>(vertexLabels.size());
        vertexLabels.forEach(vertexLabel -> results.add(VertexLabelService.join(vertexLabel, indexLabels)));
        return results;
    }

    public VertexLabelEntity get(String name, int connId) {
        HugeClient client = this.client(connId);
        try {
            VertexLabel vertexLabel = client.schema().getVertexLabel(name);
            List indexLabels = client.schema().getIndexLabels();
            return VertexLabelService.join(vertexLabel, indexLabels);
        }
        catch (ServerException e) {
            if (e.status() == 404) {
                throw new ExternalException("schema.vertexlabel.not-exist", (Throwable)e, name);
            }
            throw new ExternalException("schema.vertexlabel.get.failed", (Throwable)e, name);
        }
    }

    public void checkExist(String name, int connId) {
        this.get(name, connId);
    }

    public void checkNotExist(String name, int connId) {
        try {
            this.get(name, connId);
        }
        catch (ExternalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerException && ((ServerException)cause).status() == 404) {
                return;
            }
            throw e;
        }
        throw new ExternalException("schema.vertexlabel.exist", name);
    }

    public List<String> getLinkEdgeLabels(String name, int connId) {
        HugeClient client = this.client(connId);
        List edgeLabels = client.schema().getEdgeLabels();
        ArrayList<String> results = new ArrayList<String>();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.linkedVertexLabel(name)) continue;
            results.add(edgeLabel.name());
        }
        return results;
    }

    public void add(VertexLabelEntity entity, int connId) {
        HugeClient client = this.client(connId);
        VertexLabel vertexLabel = VertexLabelService.convert(entity, client);
        try {
            client.schema().addVertexLabel(vertexLabel);
        }
        catch (Exception e) {
            throw new ExternalException("schema.vertexlabel.create.failed", (Throwable)e, entity.getName());
        }
        List<IndexLabel> indexLabels = VertexLabelService.collectIndexLabels(entity, client);
        this.piService.addBatch(indexLabels, client);
    }

    public void update(VertexLabelUpdateEntity entity, int connId) {
        HugeClient client = this.client(connId);
        VertexLabel vertexLabel = VertexLabelService.convert(entity, client);
        List existedIndexLabels = client.schema().getIndexLabels();
        List<String> existedIndexLabelNames = VertexLabelService.collectNames(existedIndexLabels);
        List<String> addedIndexLabelNames = entity.getAppendPropertyIndexNames();
        List<IndexLabel> addedIndexLabels = VertexLabelService.convertIndexLabels(entity.getAppendPropertyIndexes(), client, true, entity.getName());
        List<String> removedIndexLabelNames = entity.getRemovePropertyIndexes();
        if (addedIndexLabelNames != null) {
            for (String name : addedIndexLabelNames) {
                if (!existedIndexLabelNames.contains(name)) continue;
                throw new ExternalException("schema.vertexlabel.update.append-index-existed", entity.getName(), name);
            }
        }
        if (removedIndexLabelNames != null) {
            for (String name : removedIndexLabelNames) {
                if (existedIndexLabelNames.contains(name)) continue;
                throw new ExternalException("schema.vertexlabel.update.remove-index-unexisted", entity.getName(), name);
            }
        }
        try {
            client.schema().appendVertexLabel(vertexLabel);
        }
        catch (Exception e) {
            throw new ExternalException("schema.vertexlabel.update.failed", (Throwable)e, entity.getName());
        }
        this.piService.addBatch(addedIndexLabels, client);
        this.piService.removeBatch(removedIndexLabelNames, client);
    }

    public void remove(String name, int connId) {
        HugeClient client = this.client(connId);
        client.schema().removeVertexLabelAsync(name);
    }

    public boolean checkUsing(String name, int connId) {
        HugeClient client = this.client(connId);
        List edgeLabels = client.schema().getEdgeLabels();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.linkedVertexLabel(name)) continue;
            return true;
        }
        return false;
    }

    public ConflictDetail checkConflict(ConflictCheckEntity entity, int connId, boolean compareEachOther) {
        ConflictDetail detail = new ConflictDetail(SchemaType.VERTEX_LABEL);
        if (CollectionUtils.isEmpty(entity.getVlEntities())) {
            return detail;
        }
        this.pkService.checkConflict(entity.getPkEntities(), detail, connId, compareEachOther);
        this.piService.checkConflict(entity.getPiEntities(), detail, connId, compareEachOther);
        this.checkConflict(entity.getVlEntities(), detail, connId, compareEachOther);
        return detail;
    }

    public void checkConflict(List<VertexLabelEntity> entities, ConflictDetail detail, int connId, boolean compareEachOther) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        HashMap<String, VertexLabelEntity> originEntities = new HashMap<String, VertexLabelEntity>();
        for (VertexLabelEntity entity : this.list(connId)) {
            originEntities.put(entity.getName(), entity);
        }
        for (VertexLabelEntity entity : entities) {
            if (detail.anyPropertyKeyConflict(entity.getPropNames())) {
                detail.add(entity, ConflictStatus.DEP_CONFLICT);
                continue;
            }
            if (detail.anyPropertyIndexConflict(entity.getIndexProps())) {
                detail.add(entity, ConflictStatus.DEP_CONFLICT);
                continue;
            }
            VertexLabelEntity originEntity = (VertexLabelEntity)originEntities.get(entity.getName());
            ConflictStatus status = SchemaEntity.compare(entity, originEntity);
            detail.add(entity, status);
        }
        if (compareEachOther) {
            VertexLabelService.compareWithEachOther(detail, SchemaType.VERTEX_LABEL);
        }
    }

    public void reuse(ConflictDetail detail, int connId) {
        List<IndexLabel> indexLabels;
        List<VertexLabel> vertexLabels;
        Ex.check(!detail.hasConflict(), "schema.cannot-reuse-conflict", new Object[0]);
        HugeClient client = this.client(connId);
        List<PropertyKey> propertyKeys = this.pkService.filter(detail, client);
        if (!propertyKeys.isEmpty()) {
            try {
                this.pkService.addBatch(propertyKeys, client);
            }
            catch (Exception e) {
                throw new ExternalException("schema.propertykey.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
        if (!(vertexLabels = this.filter(detail, client)).isEmpty()) {
            try {
                this.addBatch(vertexLabels, client);
            }
            catch (Exception e) {
                this.pkService.removeBatch(propertyKeys, client);
                throw new ExternalException("schema.vertexlabel.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
        if (!(indexLabels = this.piService.filter(detail, client)).isEmpty()) {
            try {
                this.piService.addBatch(indexLabels, client);
            }
            catch (Exception e) {
                this.removeBatch(vertexLabels, client);
                this.pkService.removeBatch(propertyKeys, client);
                throw new ExternalException("schema.propertyindex.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
    }

    public List<VertexLabel> filter(ConflictDetail detail, HugeClient client) {
        return detail.getVlConflicts().stream().filter(c -> c.getStatus() == ConflictStatus.PASSED).map(SchemaConflict::getEntity).map(e -> VertexLabelService.convert(e, client)).collect(Collectors.toList());
    }

    public void addBatch(List<VertexLabel> vertexLabels, HugeClient client) {
        BiConsumer<HugeClient, VertexLabel> consumer = (hugeClient, vl) -> hugeClient.schema().addVertexLabel(vl);
        VertexLabelService.addBatch(vertexLabels, client, consumer, SchemaType.VERTEX_LABEL);
    }

    public void removeBatch(List<VertexLabel> vertexLabels, HugeClient client) {
        List<String> names = VertexLabelService.collectNames(vertexLabels);
        BiFunction<HugeClient, String, Long> func = (hugeClient, name) -> hugeClient.schema().removeVertexLabelAsync(name);
        VertexLabelService.removeBatch(names, client, func, SchemaType.VERTEX_LABEL);
    }

    private static VertexLabelEntity join(VertexLabel vertexLabel, List<IndexLabel> indexLabels) {
        if (vertexLabel == null) {
            return null;
        }
        Set<Property> properties = VertexLabelService.collectProperties((SchemaLabel)vertexLabel);
        List<PropertyIndex> propertyIndexes = VertexLabelService.collectPropertyIndexes((SchemaLabel)vertexLabel, indexLabels);
        return VertexLabelEntity.builder().name(vertexLabel.name()).properties(properties).idStrategy(vertexLabel.idStrategy()).primaryKeys(vertexLabel.primaryKeys()).propertyIndexes(propertyIndexes).openLabelIndex(vertexLabel.enableLabelIndex()).style(VertexLabelService.getStyle((SchemaElement)vertexLabel)).createTime(VertexLabelService.getCreateTime((SchemaElement)vertexLabel)).build();
    }

    private static VertexLabelStyle getStyle(SchemaElement element) {
        String styleValue = (String)element.userdata().get("~style");
        if (styleValue != null) {
            return (VertexLabelStyle)JsonUtil.fromJson((String)styleValue, VertexLabelStyle.class);
        }
        return new VertexLabelStyle();
    }

    private static VertexLabel convert(VertexLabelEntity entity, HugeClient client) {
        if (entity == null) {
            return null;
        }
        VertexLabelStyle style = entity.getStyle();
        return (VertexLabel)client.schema().vertexLabel(entity.getName()).idStrategy(entity.getIdStrategy()).properties(VertexLabelService.toStringArray(entity.getPropNames())).primaryKeys(VertexLabelService.toStringArray(entity.getPrimaryKeys())).nullableKeys(VertexLabelService.toStringArray(entity.getNullableProps())).enableLabelIndex(entity.isOpenLabelIndex()).userdata("~create_time", (Object)entity.getCreateTime()).userdata("~style", (Object)JsonUtil.toJson((Object)style)).build();
    }

    private static VertexLabel convert(VertexLabelUpdateEntity entity, HugeClient client) {
        if (entity == null) {
            return null;
        }
        HashSet<String> properties = new HashSet<String>();
        if (entity.getAppendProperties() != null) {
            entity.getAppendProperties().forEach(p -> properties.add(p.getName()));
        }
        VertexLabel.Builder builder = client.schema().vertexLabel(entity.getName()).properties(VertexLabelService.toStringArray(properties)).nullableKeys(VertexLabelService.toStringArray(properties));
        VertexLabel vertexLabel = (VertexLabel)builder.build();
        Map userdata = vertexLabel.userdata();
        VertexLabelStyle style = entity.getStyle();
        if (style != null) {
            userdata.put("~style", JsonUtil.toJson((Object)style));
        }
        return vertexLabel;
    }
}

