/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class ConfigListConvOption<T, R>
extends TypedOption<List<T>, List<R>> {
    private final Class<T> elemClass;
    private final Function<T, R> converter;

    public ConfigListConvOption(String name, String desc, Predicate<List<T>> pred, Function<T, R> convert, T ... values) {
        this(name, false, desc, pred, convert, null, Arrays.asList(values));
    }

    public ConfigListConvOption(String name, boolean required, String desc, Predicate<List<T>> pred, Function<T, R> convert, Class<T> clazz, List<T> values) {
        super(name, required, desc, pred, values.getClass(), values);
        E.checkNotNull(convert, "convert");
        if (clazz == null && values.size() > 0) {
            clazz = values.get(0).getClass();
        }
        E.checkArgumentNotNull(clazz, "Element class can't be null", new Object[0]);
        this.elemClass = clazz;
        this.converter = convert;
    }

    @Override
    protected boolean forList() {
        return true;
    }

    @Override
    protected List<T> parse(String value) {
        return ConfigListOption.convert(value, part -> this.parse((String)part, this.elemClass));
    }

    @Override
    public List<R> convert(List<T> values) {
        ArrayList<R> results = new ArrayList<R>(values.size());
        for (T value : values) {
            results.add(this.converter.apply(value));
        }
        return results;
    }
}

