"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopeImpl = void 0;
var TokenTree_1 = require("./TokenTree");
var antlr4_1 = require("antlr4");
var FEEL_1_1Lexer_1 = require("./generated-parser/FEEL_1_1Lexer");
var VariableSymbol_1 = require("./VariableSymbol");
var FeelSyntacticSymbolNature_1 = require("../FeelSyntacticSymbolNature");
var ScopeImpl = (function () {
    function ScopeImpl(name, parentScope, type, allowDynamicVariables) {
        this.childScopes = new Map();
        this.symbols = new Map();
        this.name = name;
        this.parentScope = parentScope;
        this.type = type;
        this._allowDynamicVariables = allowDynamicVariables;
        if (parentScope) {
            parentScope.addChildScope(this);
        }
    }
    Object.defineProperty(ScopeImpl.prototype, "allowDynamicVariables", {
        get: function () {
            return this._allowDynamicVariables;
        },
        enumerable: false,
        configurable: true
    });
    ScopeImpl.prototype.addChildScope = function (scope) {
        this.childScopes.set(scope.getName(), scope);
    };
    ScopeImpl.prototype.start = function (token) {
        var _a, _b;
        if (!this.tokenTree) {
            this.initializeTokenTree();
        }
        (_a = this.tokenTree) === null || _a === void 0 ? void 0 : _a.start(token);
        if (this.getParentScope()) {
            (_b = this.getParentScope()) === null || _b === void 0 ? void 0 : _b.start(token);
        }
    };
    ScopeImpl.prototype.define = function (symbol) {
        var _a, _b, _c;
        if (this.symbols.has((_a = symbol.getId()) !== null && _a !== void 0 ? _a : "")) {
            return false;
        }
        this.symbols.set((_b = symbol.getId()) !== null && _b !== void 0 ? _b : "", symbol);
        if (this.tokenTree) {
            this.tokenTree.addName(this.tokenize((_c = symbol.getId()) !== null && _c !== void 0 ? _c : ""));
        }
        return true;
    };
    ScopeImpl.prototype.tokenize = function (symbol) {
        var input = antlr4_1.CharStreams.fromString(symbol);
        var lexer = new FEEL_1_1Lexer_1.default(input);
        var tokens = new Array();
        for (var token = lexer.nextToken(); token.type != antlr4_1.Token.EOF; token = lexer.nextToken()) {
            tokens.push(token.text);
        }
        return tokens;
    };
    ScopeImpl.prototype.followUp = function (token, isPredict) {
        var _a, _b, _c;
        var parent = (_b = (this.getParentScope() && ((_a = this.getParentScope()) === null || _a === void 0 ? void 0 : _a.followUp(token, isPredict)))) !== null && _b !== void 0 ? _b : false;
        return ((_c = this.tokenTree) === null || _c === void 0 ? void 0 : _c.followUp(token, !isPredict)) || parent;
    };
    ScopeImpl.prototype.getChildScopes = function () {
        return this.childScopes;
    };
    ScopeImpl.prototype.getName = function () {
        var _a;
        return (_a = this.name) !== null && _a !== void 0 ? _a : "";
    };
    ScopeImpl.prototype.getParentScope = function () {
        return this.parentScope;
    };
    ScopeImpl.prototype.getSymbols = function () {
        return this.symbols;
    };
    ScopeImpl.prototype.getType = function () {
        return this.type;
    };
    ScopeImpl.prototype.resolve = function (parameter) {
        if (typeof parameter === "string") {
            if (this._allowDynamicVariables) {
                return new VariableSymbol_1.VariableSymbol(parameter, {
                    name: "name",
                }, FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.DynamicVariable);
            }
            return this.resolveId(parameter);
        }
        else {
            return this.resolveQualifiedName(parameter);
        }
    };
    ScopeImpl.prototype.resolveId = function (id) {
        var s = this.symbols.get(id);
        if (s == null && this.parentScope) {
            return this.parentScope.resolve(id);
        }
        return s;
    };
    ScopeImpl.prototype.resolveQualifiedName = function (qualifiedName) {
        var _a;
        var root = this.symbols.get(qualifiedName[0]);
        if (root == null && this.parentScope) {
            return this.parentScope.resolve(qualifiedName);
        }
        else if (root != null) {
            var currentSymbol = root;
            for (var i = 1; i < qualifiedName.length && currentSymbol; i++) {
                currentSymbol = (_a = currentSymbol.getScope()) === null || _a === void 0 ? void 0 : _a.resolve(qualifiedName[i]);
            }
            return currentSymbol;
        }
        return undefined;
    };
    ScopeImpl.prototype.initializeTokenTree = function () {
        this.tokenTree = this.tokenTreeFromSymbols(this.getSymbols());
    };
    ScopeImpl.prototype.tokenTreeFromSymbols = function (symbols) {
        var e_1, _a;
        var tt = new TokenTree_1.TokenTree();
        try {
            for (var _b = __values(symbols.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var symbol = _c.value;
                var tokens = this.tokenize(symbol);
                tt.addName(tokens);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return tt;
    };
    return ScopeImpl;
}());
exports.ScopeImpl = ScopeImpl;
//# sourceMappingURL=ScopeImpl.js.map