import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Button } from "@patternfly/react-core/dist/js/components/Button/";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider/";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { HelpIcon } from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { Text } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Toolbar, ToolbarContent, ToolbarItem } from "@patternfly/react-core/dist/js/components/Toolbar/";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip/";
import { TreeView, TreeViewSearch } from "@patternfly/react-core/dist/js/components/TreeView/";
import { WarningTriangleIcon } from "@patternfly/react-icons/dist/esm/icons/warning-triangle-icon";
import { TestScenarioType } from "../TestScenarioEditor";
import { useTestScenarioEditorI18n } from "../i18n";
import { EMPTY_TYPE, TEST_SCENARIO_EXPRESSION_TYPE } from "../common/TestScenarioCommonConstants";
import { retrieveFactMappingValueIndexByIdentifiers, retrieveModelDescriptor, retrieveRowsDataFromModel, } from "../common/TestScenarioCommonFunctions";
import "./TestScenarioDrawerDataSelectorPanel.css";
function TestScenarioDataSelectorPanel({ assetType, dataObjects, scesimModel, selectedColumnMetadata, updateSelectedColumnMetaData, updateTestScenarioModel, }) {
    const { i18n } = useTestScenarioEditorI18n();
    const [allExpanded, setAllExpanded] = useState(false);
    const [dataSelectorStatus, setDataSelectorStatus] = useState(0);
    const [filteredItems, setFilteredItems] = useState(dataObjects);
    const [treeViewStatus, setTreeViewStatus] = useState({
        activeItems: [],
        searchKey: "",
        isExpanded: false,
    });
    const filterDataObjectsByID = useCallback((item, itemID) => {
        if (item.id === itemID) {
            return true;
        }
        if (item.children) {
            return ((item.children = item.children
                .map((object) => Object.assign({}, object))
                .filter((child) => filterDataObjectsByID(child, itemID))).length > 0);
        }
        return false;
    }, []);
    const findDataObjectRootParent = useCallback((dataObjects, itemId) => {
        const filtered = dataObjects
            .map((object) => Object.assign({}, object))
            .filter((item) => filterDataObjectsByID(item, itemId));
        return filtered[0];
    }, [filterDataObjectsByID]);
    const isDataObjectRootParent = useCallback((dataObjects, itemID) => {
        return dataObjects.map((object) => Object.assign({}, object)).filter((item) => item.id === itemID).length === 1;
    }, []);
    const filterTypesItems = useCallback((dataObject, factIdentifierName) => {
        return dataObject.name === factIdentifierName;
    }, []);
    const filterDataObjectByExpressionElements = useCallback((dataObject, allExpressionElements) => {
        let filtered = true;
        for (const expressionElements of allExpressionElements) {
            if (!expressionElements ||
                !expressionElements.ExpressionElement ||
                expressionElements.ExpressionElement.length === 0) {
                continue;
            }
            if (expressionElements.ExpressionElement[0].step.__$$text === dataObject.name) {
                filtered = false;
                break;
            }
        }
        return filtered;
    }, []);
    const filterDataObjectChildrenByExpressionElements = useCallback((dataObject, allExpressionElements) => {
        if (dataObject.children) {
            for (const expressionElements of allExpressionElements) {
                if (!expressionElements ||
                    !expressionElements.ExpressionElement ||
                    expressionElements.ExpressionElement.length === 0) {
                    continue;
                }
                if (expressionElements.ExpressionElement[0].step.__$$text === dataObject.name) {
                    const selected = dataObject.children.filter((dataObjectChild) => {
                        const fieldName = expressionElements.ExpressionElement.at(-1).step.__$$text;
                        if (dataObject.isSimpleTypeFact) {
                            fieldName.concat(".");
                        }
                        return dataObjectChild.name !== fieldName;
                    });
                    dataObject.children = selected;
                }
            }
        }
    }, []);
    const filterOutAlreadyAssignedDataObjectsAndChildren = useCallback((expressionElement, isBackground) => {
        const testScenarioDescriptor = retrieveModelDescriptor(scesimModel.ScenarioSimulationModel, isBackground);
        const assignedExpressionElements = testScenarioDescriptor.factMappings.FactMapping.map((factMapping) => factMapping.expressionElements);
        const filteredDataObjects = dataObjects
            .map((object) => JSON.parse(JSON.stringify(object)))
            .filter((dataObject) => !filterDataObjectByExpressionElements(dataObject, [expressionElement]));
        filteredDataObjects.forEach((dataObject) => filterDataObjectChildrenByExpressionElements(dataObject, assignedExpressionElements));
        return filteredDataObjects;
    }, [
        dataObjects,
        filterDataObjectByExpressionElements,
        filterDataObjectChildrenByExpressionElements,
        scesimModel.ScenarioSimulationModel,
    ]);
    const filterItems = useCallback((item, input) => {
        if (item.name.toLowerCase().includes(input.toLowerCase())) {
            return true;
        }
        if (item.children) {
            return ((item.children = item.children
                .map((object) => Object.assign({}, object))
                .filter((child) => filterItems(child, input))).length > 0);
        }
    }, []);
    useEffect(() => {
        var _a;
        console.debug("========SELECTOR PANEL USE EFFECT===========");
        console.debug("Selected Column:");
        console.debug(selectedColumnMetadata);
        console.debug("All Data Objects:");
        console.debug(dataObjects);
        if (!selectedColumnMetadata || ((_a = selectedColumnMetadata.factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) == "OTHER") {
            setDataSelectorStatus(0);
            setFilteredItems(dataObjects);
            setTreeViewStatus({ activeItems: [], searchKey: "", isExpanded: false });
            console.debug("Case 1");
            console.debug("=============USE EFFECT END===============");
            return;
        }
        if (selectedColumnMetadata.factMapping.className.__$$text === EMPTY_TYPE) {
            const isFactIdentifierAssigned = selectedColumnMetadata.factMapping.factIdentifier.className.__$$text !== EMPTY_TYPE;
            let filteredDataObjects = [];
            if (isFactIdentifierAssigned) {
                const expressionElement = selectedColumnMetadata.factMapping.expressionElements;
                filteredDataObjects = filterOutAlreadyAssignedDataObjectsAndChildren(expressionElement, selectedColumnMetadata.isBackground);
            }
            else {
                const testScenarioDescriptor = retrieveModelDescriptor(scesimModel.ScenarioSimulationModel, selectedColumnMetadata.isBackground);
                const assignedExpressionElements = testScenarioDescriptor.factMappings.FactMapping.map((factMapping) => factMapping.expressionElements);
                filteredDataObjects = dataObjects
                    .map((object) => JSON.parse(JSON.stringify(object)))
                    .filter((dataObject) => filterDataObjectByExpressionElements(dataObject, assignedExpressionElements));
            }
            const isUserFilterPresent = treeViewStatus.searchKey.trim() !== "";
            if (isUserFilterPresent) {
                filteredDataObjects = filteredDataObjects.filter((item) => filterItems(item, treeViewStatus.searchKey));
            }
            setDataSelectorStatus(1);
            setFilteredItems(filteredDataObjects);
            setTreeViewStatus((prev) => {
                return Object.assign(Object.assign({}, prev), { activeItems: [], isExpanded: isFactIdentifierAssigned || isUserFilterPresent });
            });
            console.debug("Case 2");
            console.debug("Filtered Data Objects:");
            console.debug(filteredDataObjects);
            console.debug("=============USE EFFECT END===============");
            return;
        }
        const factIdentifier = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement[0].step.__$$text;
        const filteredDataObjects = dataObjects.filter((dataObject) => filterTypesItems(dataObject, factIdentifier));
        const isExpressionType = selectedColumnMetadata.factMapping.factMappingValueType.__$$text ===
            TEST_SCENARIO_EXPRESSION_TYPE[TEST_SCENARIO_EXPRESSION_TYPE.EXPRESSION];
        const isSimpleTypeFact = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement.length === 1 &&
            selectedColumnMetadata.factMapping.className.__$$text !== EMPTY_TYPE;
        let fieldID;
        if (isExpressionType) {
            fieldID = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement[0].step.__$$text;
        }
        else if (isSimpleTypeFact) {
            fieldID = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement[0].step.__$$text.concat(".");
        }
        else {
            fieldID = selectedColumnMetadata.factMapping
                .expressionElements.ExpressionElement.map((expressionElement) => expressionElement.step.__$$text)
                .join(".");
        }
        const treeViewItemToActivate = filteredDataObjects
            .reduce((acc, item) => {
            return item.children ? acc.concat(item.children) : acc;
        }, [])
            .filter((item) => item.id === fieldID);
        setDataSelectorStatus(2);
        setFilteredItems(filteredDataObjects);
        setTreeViewStatus({ activeItems: treeViewItemToActivate, searchKey: "", isExpanded: true });
        console.debug("Case 3");
        console.debug("=============USE EFFECT END===============");
    }, [
        dataObjects,
        filterDataObjectByExpressionElements,
        filterDataObjectChildrenByExpressionElements,
        filterOutAlreadyAssignedDataObjectsAndChildren,
        filterItems,
        filterTypesItems,
        scesimModel,
        selectedColumnMetadata,
        treeViewStatus.searchKey,
    ]);
    const treeViewEmptyStatus = useMemo(() => {
        const isTreeViewNotEmpty = dataObjects.length > 0;
        const treeViewEmptyIcon = filteredItems.length === 0 ? WarningTriangleIcon : WarningTriangleIcon;
        const title = dataObjects.length === 0
            ? assetType === TestScenarioType[TestScenarioType.DMN]
                ? i18n.drawer.dataSelector.emptyDataObjectsTitleDMN
                : i18n.drawer.dataSelector.emptyDataObjectsTitleRule
            : "No more properties";
        const description = dataObjects.length === 0
            ? assetType === TestScenarioType[TestScenarioType.DMN]
                ? i18n.drawer.dataSelector.emptyDataObjectsDescriptionDMN
                : i18n.drawer.dataSelector.emptyDataObjectsDescriptionRule
            : "All the properties have been already assigned";
        {
            assetType === TestScenarioType[TestScenarioType.DMN]
                ? i18n.drawer.dataSelector.emptyDataObjectsTitleDMN
                : i18n.drawer.dataSelector.emptyDataObjectsTitleRule;
        }
        return { description: description, enabled: isTreeViewNotEmpty, icon: treeViewEmptyIcon, title: title };
    }, [assetType, dataObjects.length, filteredItems.length, i18n]);
    const insertDataObjectButtonStatus = useMemo(() => {
        var _a;
        if (!selectedColumnMetadata) {
            return {
                message: i18n.drawer.dataSelector.insertDataObjectTooltipColumnSelectionMessage,
                enabled: false,
            };
        }
        const oneActiveTreeViewItem = treeViewStatus.activeItems.length === 1;
        if (!oneActiveTreeViewItem) {
            return { message: i18n.drawer.dataSelector.insertDataObjectTooltipDataObjectSelectionMessage, enabled: false };
        }
        const expressionElement = selectedColumnMetadata.factMapping.expressionElements;
        const filteredDataObjects = filterOutAlreadyAssignedDataObjectsAndChildren(expressionElement, selectedColumnMetadata.isBackground);
        const isAlreadyAssigined = filteredDataObjects.length === 1 &&
            !((_a = filteredDataObjects[0].children) === null || _a === void 0 ? void 0 : _a.find((child) => child.id === treeViewStatus.activeItems[0].id));
        if (oneActiveTreeViewItem && isAlreadyAssigined) {
            return {
                message: i18n.drawer.dataSelector.insertDataObjectTooltipDataObjectAlreadyAssignedMessage,
                enabled: false,
            };
        }
        return { message: i18n.drawer.dataSelector.insertDataObjectTooltipDataObjectAssignMessage, enabled: true };
    }, [filterOutAlreadyAssignedDataObjectsAndChildren, i18n, selectedColumnMetadata, treeViewStatus.activeItems]);
    const onAllExpandedToggle = useCallback((_event) => {
        setAllExpanded((prev) => !prev);
    }, []);
    const onInsertDataObjectClick = useCallback(() => {
        updateTestScenarioModel((prevState) => {
            const isBackground = selectedColumnMetadata.isBackground;
            const factMappings = retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings
                .FactMapping;
            const deepClonedFactMappings = JSON.parse(JSON.stringify(factMappings));
            const isRootType = isDataObjectRootParent(dataObjects, treeViewStatus.activeItems[0].id.toString());
            const rootDataObject = findDataObjectRootParent(dataObjects, treeViewStatus.activeItems[0].id.toString());
            const className = treeViewStatus.activeItems[0].customBadgeContent.toString();
            const expressionAlias = isRootType ? "Expression </>" : treeViewStatus.activeItems[0].name.toString();
            const expressionElementsSteps = treeViewStatus.activeItems[0].id.split(".").filter((step) => !!step.trim());
            const factName = treeViewStatus.activeItems[0].id.split(".")[0];
            const factClassName = isRootType
                ? treeViewStatus.activeItems[0].customBadgeContent.toString()
                : rootDataObject.customBadgeContent.toString();
            const factMappingValueType = isRootType
                ? TEST_SCENARIO_EXPRESSION_TYPE[TEST_SCENARIO_EXPRESSION_TYPE.EXPRESSION]
                : TEST_SCENARIO_EXPRESSION_TYPE[TEST_SCENARIO_EXPRESSION_TYPE.NOT_EXPRESSION];
            const factMappingToUpdate = deepClonedFactMappings[selectedColumnMetadata.index];
            factMappingToUpdate.className = { __$$text: className };
            factMappingToUpdate.factAlias = { __$$text: factName };
            factMappingToUpdate.factIdentifier.className = { __$$text: factClassName };
            factMappingToUpdate.factIdentifier.name = { __$$text: factName };
            factMappingToUpdate.factMappingValueType = { __$$text: factMappingValueType };
            factMappingToUpdate.expressionAlias = { __$$text: expressionAlias };
            factMappingToUpdate.expressionElements = {
                ExpressionElement: expressionElementsSteps.map((ee) => {
                    return { step: { __$$text: ee } };
                }),
            };
            const deepClonedRowsData = JSON.parse(JSON.stringify(retrieveRowsDataFromModel(prevState.ScenarioSimulationModel, isBackground)));
            deepClonedRowsData.forEach((fmv, index) => {
                const factMappingValues = fmv.factMappingValues.FactMappingValue;
                const newFactMappingValues = [...factMappingValues];
                const factMappingValueToUpdateIndex = retrieveFactMappingValueIndexByIdentifiers(newFactMappingValues, selectedColumnMetadata.factMapping.factIdentifier, selectedColumnMetadata.factMapping.expressionIdentifier);
                const factMappingValueToUpdate = factMappingValues[factMappingValueToUpdateIndex];
                newFactMappingValues[factMappingValueToUpdateIndex] = Object.assign(Object.assign({}, factMappingValueToUpdate), { factIdentifier: { className: { __$$text: factClassName }, name: { __$$text: factName } } });
                deepClonedRowsData[index].factMappingValues.FactMappingValue = newFactMappingValues;
            });
            updateSelectedColumnMetaData({
                factMapping: JSON.parse(JSON.stringify(factMappingToUpdate)),
                index: selectedColumnMetadata.index,
                isBackground: isBackground,
            });
            return {
                ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: {
                        scesimModelDescriptor: {
                            factMappings: {
                                FactMapping: isBackground
                                    ? prevState.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping
                                    : deepClonedFactMappings,
                            },
                        },
                        scesimData: {
                            Scenario: isBackground
                                ? prevState.ScenarioSimulationModel.simulation.scesimData.Scenario
                                : deepClonedRowsData,
                        },
                    }, background: {
                        scesimModelDescriptor: {
                            factMappings: {
                                FactMapping: isBackground
                                    ? deepClonedFactMappings
                                    : prevState.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping,
                            },
                        },
                        scesimData: {
                            BackgroundData: isBackground
                                ? deepClonedRowsData
                                : prevState.ScenarioSimulationModel.background.scesimData.BackgroundData,
                        },
                    } }),
            };
        });
    }, [
        dataObjects,
        findDataObjectRootParent,
        isDataObjectRootParent,
        selectedColumnMetadata,
        treeViewStatus.activeItems,
        updateSelectedColumnMetaData,
        updateTestScenarioModel,
    ]);
    const onClearSelectionClicked = useCallback((_event) => {
        setTreeViewStatus((prev) => {
            return Object.assign(Object.assign({}, prev), { activeItems: [] });
        });
    }, []);
    const onSearchTreeView = useCallback((event) => setTreeViewStatus((prev) => {
        return Object.assign(Object.assign({}, prev), { searchKey: event.target.value });
    }), []);
    const onSelectTreeViewItem = useCallback((_event, treeViewItem) => {
        setTreeViewStatus((prev) => {
            return Object.assign(Object.assign({}, prev), { activeItems: [treeViewItem] });
        });
    }, []);
    const treeViewSearchToolbar = (_jsx(Toolbar, Object.assign({ style: { padding: 0 } }, { children: _jsx(ToolbarContent, Object.assign({ style: { padding: 0 } }, { children: _jsx(ToolbarItem, Object.assign({ widths: { default: "100%" } }, { children: _jsx(TreeViewSearch, { disabled: dataSelectorStatus !== 1, id: "input-search", name: "search-input", onSearch: onSearchTreeView, value: treeViewStatus.searchKey }) })) })) })));
    return (_jsxs(_Fragment, { children: [_jsxs(Text, Object.assign({ className: "kie-scesim-editor-drawer-data-objects--text" }, { children: [assetType === TestScenarioType[TestScenarioType.DMN]
                        ? i18n.drawer.dataSelector.descriptionDMN
                        : i18n.drawer.dataSelector.descriptionRule, _jsx(Tooltip, Object.assign({ content: assetType === TestScenarioType[TestScenarioType.DMN]
                            ? i18n.drawer.dataSelector.dataObjectsDescriptionDMN
                            : i18n.drawer.dataSelector.dataObjectsDescriptionRule }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-drawer-data-objects--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] })), _jsx(Divider, {}), _jsx("div", Object.assign({ className: "kie-scesim-editor-drawer-data-objects--selector" }, { children: treeViewEmptyStatus.enabled ? (_jsx("div", Object.assign({ "aria-disabled": true }, { children: _jsx(TreeView, { activeItems: treeViewStatus.activeItems, allExpanded: allExpanded || treeViewStatus.isExpanded, className: dataSelectorStatus !== 0
                            ? undefined
                            : "kie-scesim-editor-drawer-data-objects--selector-disabled", data: filteredItems, hasBadges: true, hasSelectableNodes: true, onSelect: onSelectTreeViewItem, toolbar: treeViewSearchToolbar }) }))) : (_jsx(Bullseye, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: treeViewEmptyStatus.icon }), _jsx(Title, Object.assign({ headingLevel: "h4", size: "lg" }, { children: treeViewEmptyStatus.title })), _jsx(EmptyStateBody, { children: treeViewEmptyStatus.description })] }) })) })), _jsx(Divider, {}), _jsxs("div", Object.assign({ className: "kie-scesim-editor-drawer-data-objects--button-container" }, { children: [_jsx(Tooltip, Object.assign({ content: insertDataObjectButtonStatus.message }, { children: _jsx(Button, Object.assign({ isAriaDisabled: !insertDataObjectButtonStatus.enabled, onClick: onInsertDataObjectClick, variant: "primary" }, { children: i18n.drawer.dataSelector.insertDataObject })) })), _jsx(Button, Object.assign({ isDisabled: treeViewStatus.activeItems.length !== 1 || dataSelectorStatus !== 1, onClick: onClearSelectionClicked, variant: "secondary" }, { children: i18n.drawer.dataSelector.clearSelection })), _jsx(Button, Object.assign({ isDisabled: filteredItems.length < 1 ||
                            treeViewStatus.isExpanded ||
                            dataSelectorStatus !== 1, onClick: onAllExpandedToggle, variant: "link" }, { children: allExpanded ? i18n.drawer.dataSelector.collapseAll : i18n.drawer.dataSelector.expandAll }))] }))] }));
}
export default TestScenarioDataSelectorPanel;
//# sourceMappingURL=TestScenarioDrawerDataSelectorPanel.js.map