"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCompletionItem = void 0;
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
function createCompletionItem(args) {
    var _a;
    return __assign({ kind: args.kind, label: args.label, sortText: "100_".concat(args.label), filterText: (_a = args.filterText) !== null && _a !== void 0 ? _a : args.label, detail: args.detail, textEdit: {
            newText: args.codeCompletionStrategy.translate(__assign(__assign({}, args), { completionItemKind: args.kind })),
            range: args.overwriteRange,
        }, insertTextFormat: vscode_languageserver_types_1.InsertTextFormat.Snippet }, args.extraOptions);
}
exports.createCompletionItem = createCompletionItem;
//# sourceMappingURL=EditorLanguageServiceCodeCompletion.js.map