var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { snapPoint } from "../SnapGrid";
import { PositionalNodeHandleId } from "../connections/PositionalNodeHandles";
import { getLineRectangleIntersectionPoint, getHandlePosition, pointsToPath } from "../maths/DmnMaths";
import { getBoundsCenterPoint } from "../maths/Maths";
import { getDiscretelyAutoPositionedEdgeParams } from "../maths/Maths";
import { AutoPositionedEdgeMarker } from "./AutoPositionedEdgeMarker";
export function getSnappedMultiPointAnchoredEdgePath(_a) {
    var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
    var _m;
    var snapGrid = _a.snapGrid, dmnEdge = _a.dmnEdge, sourceNodeBounds = _a.sourceNodeBounds, targetNodeBounds = _a.targetNodeBounds, dmnShapeSource = _a.dmnShapeSource, dmnShapeTarget = _a.dmnShapeTarget;
    if (!sourceNodeBounds || !targetNodeBounds) {
        return { path: undefined, points: [] };
    }
    var points = new Array(Math.max(2, (_c = (_b = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"]) === null || _b === void 0 ? void 0 : _b.length) !== null && _c !== void 0 ? _c : 0));
    var discreteAuto = getDiscretelyAutoPositionedEdgeParams(sourceNodeBounds, targetNodeBounds);
    if ((_d = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["@_id"]) === null || _d === void 0 ? void 0 : _d.endsWith(AutoPositionedEdgeMarker.BOTH)) {
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    else if ((_e = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["@_id"]) === null || _e === void 0 ? void 0 : _e.endsWith(AutoPositionedEdgeMarker.SOURCE)) {
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
    }
    else if ((_f = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["@_id"]) === null || _f === void 0 ? void 0 : _f.endsWith(AutoPositionedEdgeMarker.TARGET)) {
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    if (!(dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"])) {
        console.warn("DMN DIAGRAM: No waypoints found. Creating a default straight line.");
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    else if ((dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"].length) < 2) {
        console.warn("DMN DIAGRAM: Invalid waypoints for edge. Creating a default straight line.");
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    else {
        var firstWaypoint = dmnEdge["di:waypoint"][0];
        var secondWaypoint = (_g = points[1]) !== null && _g !== void 0 ? _g : dmnEdge["di:waypoint"][1];
        var sourceHandlePoint = getSnappedHandlePosition(dmnShapeSource, sourceNodeBounds, firstWaypoint, points.length === 2 ? getBoundsCenterPoint(targetNodeBounds) : snapPoint(snapGrid, secondWaypoint));
        (_h = points[0]) !== null && _h !== void 0 ? _h : (points[0] = sourceHandlePoint);
        var lastWaypoint = dmnEdge["di:waypoint"][dmnEdge["di:waypoint"].length - 1];
        var secondToLastWaypoint = (_j = points[points.length - 2]) !== null && _j !== void 0 ? _j : dmnEdge["di:waypoint"][dmnEdge["di:waypoint"].length - 2];
        var targetHandlePoint = getSnappedHandlePosition(dmnShapeTarget, targetNodeBounds, lastWaypoint, points.length === 2 ? getBoundsCenterPoint(sourceNodeBounds) : snapPoint(snapGrid, secondToLastWaypoint));
        (_k = points[_m = points.length - 1]) !== null && _k !== void 0 ? _k : (points[_m] = targetHandlePoint);
    }
    for (var i = 1; i < points.length - 1; i++) {
        points[i] = snapPoint(snapGrid, __assign({}, ((_l = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"]) !== null && _l !== void 0 ? _l : [])[i]));
    }
    return { path: pointsToPath(points), points: points };
}
export function getSnappedHandlePosition(shape, snappedNode, originalHandleWaypoint, snappedSecondWaypoint) {
    var _a;
    var _b, _c, _d, _e;
    var handlePosition = getHandlePosition({ shapeBounds: shape["dc:Bounds"], waypoint: originalHandleWaypoint }).handlePosition;
    var centerHandleWaypoint = getBoundsCenterPoint(snappedNode);
    var nodeRectangle = {
        x: (_b = snappedNode.x) !== null && _b !== void 0 ? _b : 0,
        y: (_c = snappedNode.y) !== null && _c !== void 0 ? _c : 0,
        width: (_d = snappedNode.width) !== null && _d !== void 0 ? _d : 0,
        height: (_e = snappedNode.height) !== null && _e !== void 0 ? _e : 0,
    };
    return switchExpression(handlePosition, (_a = {},
        _a[PositionalNodeHandleId.Top] = { "@_x": nodeRectangle.x + nodeRectangle.width / 2, "@_y": nodeRectangle.y },
        _a[PositionalNodeHandleId.Right] = {
            "@_x": nodeRectangle.x + nodeRectangle.width,
            "@_y": nodeRectangle.y + nodeRectangle.height / 2,
        },
        _a[PositionalNodeHandleId.Bottom] = {
            "@_x": nodeRectangle.x + nodeRectangle.width / 2,
            "@_y": nodeRectangle.y + nodeRectangle.height,
        },
        _a[PositionalNodeHandleId.Left] = { "@_x": nodeRectangle.x, "@_y": nodeRectangle.y + nodeRectangle.height / 2 },
        _a[PositionalNodeHandleId.Center] = getLineRectangleIntersectionPoint(snappedSecondWaypoint, centerHandleWaypoint, nodeRectangle),
        _a));
}
//# sourceMappingURL=getSnappedMultiPointAnchoredEdgePath.js.map