import { MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { ProcessDetailsChannelApi, ProcessDetailsDriver } from "../api";
import { NodeInstance, SvgErrorResponse, SvgSuccessResponse, TriggerableNode } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { Job, JobOperationResult, ProcessInstance } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export default class ProcessDetailsEnvelopeViewDriver implements ProcessDetailsDriver {
    private readonly channelApi;
    constructor(channelApi: MessageBusClientApi<ProcessDetailsChannelApi>);
    getProcessDiagram(data: ProcessInstance): Promise<SvgSuccessResponse | SvgErrorResponse>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    cancelJob(job: Pick<Job, "id" | "endpoint">): Promise<JobOperationResult>;
    rescheduleJob(job: any, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(processInstance: ProcessInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(processInstance: ProcessInstance, node: TriggerableNode): Promise<void>;
    handleProcessVariableUpdate(processInstance: ProcessInstance, updatedJson: Record<string, unknown>): any;
    processDetailsQuery(id: string): Promise<ProcessInstance>;
    jobsQuery(id: string): Promise<Job[]>;
    openProcessInstanceDetails(id: string): void;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleNodeInstanceCancel(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleNodeInstanceRetrigger(processInstance: ProcessInstance, node: Pick<NodeInstance, "id">): Promise<void>;
}
//# sourceMappingURL=ProcessDetailsEnvelopeViewDriver.d.ts.map