import React, { useMemo, useState } from "react";
import { Dropdown, DropdownItem, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { checkProcessInstanceState } from "../utils/ProcessListUtils";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessListActionsKebab = ({ processInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent, ouiaId, ouiaSafe, }) => {
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const onSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const dropDownList = useMemo(() => {
        const result = [];
        if (processInstance.state === ProcessInstanceState.Error) {
            result.push(React.createElement(DropdownItem, { key: "Retry", onClick: () => onRetryClick(processInstance) }, "Retry"));
            result.push(React.createElement(DropdownItem, { key: "Skip", onClick: () => onSkipClick(processInstance) }, "Skip"));
        }
        if (onOpenTriggerCloudEvent) {
            result.push(React.createElement(DropdownItem, { key: "CloudEvent", onClick: () => onOpenTriggerCloudEvent(processInstance) }, "Send Cloud Event"));
        }
        result.push(React.createElement(DropdownItem, { key: "Abort", onClick: () => onAbortClick(processInstance) }, "Abort"));
        return result;
    }, [processInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent]);
    return (React.createElement(Dropdown, Object.assign({ onSelect: onSelect, toggle: React.createElement(KebabToggle, { isDisabled: checkProcessInstanceState(processInstance), onToggle: onToggle, "data-testid": "kebab-toggle", id: "kebab-toggle" }), isOpen: isKebabOpen, isPlain: true, position: "right", "aria-label": "process instance actions dropdown", "aria-labelledby": "process instance actions dropdown", dropdownItems: dropDownList }, componentOuiaProps(ouiaId, "process-list-actions-kebab", ouiaSafe))));
};
export default ProcessListActionsKebab;
//# sourceMappingURL=ProcessListActionsKebab.js.map