var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import CustomDashboardListToolbar from "../CustomDashboardListToolbar/CustomDashboardListToolbar";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import CustomDashboardsTable from "../CustomDashboardsTable/CustomDashboardsTable";
import CustomDashboardsGallery from "../CustomDashboardsGallery/CustomDashboardsGallery";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
const CustomDashboardList = ({ isEnvelopeConnectedToChannel, driver, ouiaId, ouiaSafe, }) => {
    const [filterNames, setFilterNames] = useState([]);
    const [dashboardData, setDashboardData] = useState([]);
    const [isSelected] = useState({
        tableView: true,
        cardsView: false,
    });
    const [isLoading, setIsLoading] = useState(true);
    const [error, setError] = useState(null);
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
    }, [isEnvelopeConnectedToChannel]);
    const init = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            const namesFilter = yield driver.getCustomDashboardFilter();
            setFilterNames(namesFilter.customDashboardNames);
            setIsLoading(true);
            const response = yield driver.getCustomDashboardsQuery();
            setDashboardData(response);
            setIsLoading(false);
        }
        catch (errorResponse) {
            setError(errorResponse);
        }
    });
    const applyFilter = (filters) => {
        driver.applyFilter(filters);
        init();
    };
    if (error) {
        return React.createElement(ServerErrors, { error: error.message, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "custom-dashboard-list", ouiaSafe)),
        React.createElement(Split, { hasGutter: true },
            React.createElement(SplitItem, null,
                React.createElement(CustomDashboardListToolbar, { applyFilter: applyFilter, setFilterDashboardNames: setFilterNames, filterDashboardNames: filterNames })),
            React.createElement(SplitItem, { isFilled: true })),
        React.createElement(Divider, null),
        isSelected.tableView ? (React.createElement(CustomDashboardsTable, { driver: driver, customDashboardData: dashboardData, setDashboardsData: setDashboardData, isLoading: isLoading })) : (React.createElement(CustomDashboardsGallery, { customDashboardsDatas: dashboardData, driver: driver, isLoading: isLoading }))));
};
export default CustomDashboardList;
//# sourceMappingURL=CustomDashboardList.js.map