"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStates = exports.getEvents = exports.getFunctions = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
function getNodes(args) {
    var _a;
    var node = (0, channel_1.findNodeAtLocation)(args.rootNode, args.path);
    if ((node === null || node === void 0 ? void 0 : node.type) !== args.nodeType) {
        return [];
    }
    return Array.from((_a = node.children) !== null && _a !== void 0 ? _a : []).flatMap(function (childNode) {
        var nodeProps = {};
        args.fields.forEach(function (field) {
            var _a;
            nodeProps[field] = (_a = (0, channel_1.findNodeAtLocation)(childNode, [field])) === null || _a === void 0 ? void 0 : _a.value;
        });
        return [__assign({}, nodeProps)];
    });
}
function getFunctions(rootNode) {
    return getNodes({
        rootNode: rootNode,
        path: ["functions"],
        nodeType: "array",
        fields: ["name", "operation"],
    }).filter(function (f) { return f.name && f.operation; });
}
exports.getFunctions = getFunctions;
function getEvents(rootNode) {
    return getNodes({
        rootNode: rootNode,
        path: ["events"],
        nodeType: "array",
        fields: ["name"],
    }).filter(function (e) { return e.name; });
}
exports.getEvents = getEvents;
function getStates(rootNode) {
    return getNodes({
        rootNode: rootNode,
        path: ["states"],
        nodeType: "array",
        fields: ["name"],
    }).filter(function (e) { return e.name; });
}
exports.getStates = getStates;
//# sourceMappingURL=modelQueries.js.map