"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMetas = exports.build = exports.resolveElement = exports.parse = exports.getParser = exports.getInstanceNsFromJson = exports.getInstanceNs = exports.domParser = void 0;
exports.domParser = {
    getDomDocument: function (xml) {
        var domdoc = new DOMParser().parseFromString(xml.toString(), "application/xml");
        return domdoc;
    },
};
function getInstanceNs(domdoc) {
    var nsMap = new Map(__spreadArray([], __read(domdoc.documentElement.attributes), false).flatMap(function (attr) {
        if (!attr.name.startsWith("xmlns")) {
            return [];
        }
        var nsUri = attr.value;
        var s = attr.name.split(":");
        if (s.length === 1) {
            return [
                [nsUri, ""],
                ["", nsUri],
            ];
        }
        else if (s.length === 2) {
            return [
                [nsUri, "".concat(s[1], ":")],
                ["".concat(s[1], ":"), nsUri],
            ];
        }
        else {
            throw new Error("Invalid xmlns mapping attribute '".concat(attr.name, "'"));
        }
    }));
    return nsMap;
}
exports.getInstanceNs = getInstanceNs;
function getInstanceNsFromJson(rootElement) {
    var nsMap = new Map(__spreadArray([], __read(Object.entries(rootElement)), false).flatMap(function (_a) {
        var _b = __read(_a, 2), attr = _b[0], value = _b[1];
        if (!attr.startsWith("@_xmlns")) {
            return [];
        }
        var nsUri = value !== null && value !== void 0 ? value : "";
        var s = attr.split(":");
        if (s.length === 1) {
            return [
                [nsUri, ""],
                ["", nsUri],
            ];
        }
        else if (s.length === 2) {
            return [
                [nsUri, "".concat(s[1], ":")],
                ["".concat(s[1], ":"), nsUri],
            ];
        }
        else {
            throw new Error("Invalid xmlns mapping attribute '".concat(attr, "'"));
        }
    }));
    return nsMap;
}
exports.getInstanceNsFromJson = getInstanceNsFromJson;
function getParser(args) {
    return {
        parse: function (parseArgs) {
            var _a;
            var domdoc = parseArgs.type === "domdoc" ? parseArgs.domdoc : exports.domParser.getDomDocument(parseArgs.xml);
            var instanceNs = parseArgs.type === "domdoc" ? parseArgs.instanceNs : getInstanceNs(domdoc);
            var rootType = (_a = {}, _a[args.root.element] = { type: args.root.type, isArray: false, xsdType: "", fromType: "" }, _a);
            var json = parse(__assign(__assign({}, args), { instanceNs: instanceNs, node: domdoc, nodeMetaType: rootType }));
            return { json: json, instanceNs: instanceNs };
        },
        build: function (_a) {
            var e_1, _b, _c;
            var _d;
            var json = _a.json, instanceNs = _a.instanceNs;
            var __json = JSON.parse(JSON.stringify(json));
            try {
                for (var _e = __values(__spreadArray([], __read(args.ns.entries()), false)), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var _g = __read(_f.value, 2), k = _g[0], v = _g[1];
                    if (k.endsWith(":") || k === "") {
                        var instanceNsKey = (_d = instanceNs.get(v)) === null || _d === void 0 ? void 0 : _d.slice(0, -1);
                        var originalXmlnsPropName = instanceNsKey ? "@_xmlns:".concat(instanceNsKey) : "@_xmlns";
                        if (!instanceNsKey || !__json[args.root.element][originalXmlnsPropName]) {
                            var nsName = k.slice(0, -1);
                            var newXmlnsPropName = nsName ? "@_xmlns:".concat(nsName) : "@_xmlns";
                            console.warn("Adding NS mapping to XML: ".concat(newXmlnsPropName, " --> ").concat(v));
                            __json[args.root.element][newXmlnsPropName] = v;
                        }
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_1) throw e_1.error; }
            }
            __json["?xml"] = {
                "@_version": "1.0",
                "@_encoding": "UTF-8",
            };
            var rootMetaType = (_c = {},
                _c[args.root.element] = { type: args.root.type, fromType: "root", isArray: false, xsdType: "// root" },
                _c);
            var xml = build({
                json: __json,
                ns: args.ns,
                instanceNs: instanceNs,
                elements: args.elements,
                meta: args.meta,
                metaType: rootMetaType,
                indent: "",
            });
            return xml;
        },
    };
}
exports.getParser = getParser;
function parse(args) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    var _k;
    var json = {};
    var children = args.node.childNodes;
    for (var ii = 0; ii < children.length; ii++) {
        var elemNode = children[ii];
        if (elemNode.nodeType === 1) {
            var _l = resolveElement(elemNode.nodeName, args.nodeMetaType, args), nsedName = _l.nsedName, subsedName = _l.subsedName;
            var elemMetaProp = (_a = args.nodeMetaType) === null || _a === void 0 ? void 0 : _a[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName];
            var elemMetaType = (_b = args.meta[args.elements[nsedName]]) !== null && _b !== void 0 ? _b : (elemMetaProp
                ? args.meta[elemMetaProp.type]
                : undefined);
            var t = (_d = (_c = elemMetaType === null || elemMetaType === void 0 ? void 0 : elemMetaType["__$$text"]) === null || _c === void 0 ? void 0 : _c.type) !== null && _d !== void 0 ? _d : elemMetaProp === null || elemMetaProp === void 0 ? void 0 : elemMetaProp.type;
            var elemValue = {};
            if (t === "string") {
                elemValue["__$$text"] = (_e = elemNode.textContent) !== null && _e !== void 0 ? _e : "";
            }
            else if (t === "boolean") {
                elemValue["__$$text"] = parseBoolean((_f = elemNode.textContent) !== null && _f !== void 0 ? _f : "");
            }
            else if (t === "float") {
                elemValue["__$$text"] = parseFloat((_g = elemNode.textContent) !== null && _g !== void 0 ? _g : "");
            }
            else if (t === "integer") {
                elemValue["__$$text"] = parseFloat((_h = elemNode.textContent) !== null && _h !== void 0 ? _h : "");
            }
            else {
                elemValue = parse(__assign(__assign({}, args), { node: elemNode, nodeMetaType: elemMetaType }));
                if (subsedName !== nsedName) {
                    elemValue["__$$element"] = nsedName;
                }
            }
            var attrs = elemNode.attributes;
            for (var i = 0; i < attrs.length; i++) {
                var attr = attrs[i];
                var attrPropType = elemMetaType === null || elemMetaType === void 0 ? void 0 : elemMetaType["@_".concat(attr.name)];
                var attrValue = void 0;
                if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "string") {
                    attrValue = attr.value;
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "boolean") {
                    attrValue = parseBoolean(attr.value);
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "float") {
                    attrValue = parseFloat(attr.value);
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "integer") {
                    attrValue = parseFloat(attr.value);
                }
                else if ((attrPropType === null || attrPropType === void 0 ? void 0 : attrPropType.type) === "allNNI") {
                    attrValue = parseAllNNI(attr.value);
                }
                else {
                    attrValue = attr.value;
                }
                elemValue["@_".concat(attr.name)] = attrValue;
            }
            var currentValue = json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName];
            if (elemMetaProp === null || elemMetaProp === void 0 ? void 0 : elemMetaProp.isArray) {
                (_j = json[_k = subsedName !== null && subsedName !== void 0 ? subsedName : nsedName]) !== null && _j !== void 0 ? _j : (json[_k] = []);
                json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName].push(elemValue);
            }
            else if (currentValue) {
                if (elemMetaProp && !elemMetaProp.isArray) {
                    console.warn("[xml-parser-ts] Accumulating values on known non-array property '".concat(subsedName, "' (").concat(nsedName, ") of type '").concat(elemMetaProp.type, "'."));
                }
                if (Array.isArray(currentValue)) {
                    currentValue.push(elemValue);
                }
                else {
                    json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName] = [currentValue, elemValue];
                }
            }
            else {
                json[subsedName !== null && subsedName !== void 0 ? subsedName : nsedName] = elemValue;
            }
        }
    }
    return json;
}
exports.parse = parse;
function resolveElement(name, parentMetaType, _a) {
    var _b, _c;
    var ns = _a.ns, instanceNs = _a.instanceNs, subs = _a.subs;
    var nameNs = undefined;
    var nameName = undefined;
    var s = name.split(":");
    if (s.length === 1) {
        nameNs = (_b = ns.get(instanceNs.get(""))) !== null && _b !== void 0 ? _b : "";
        nameName = s[0];
    }
    else if (s.length === 2) {
        nameNs = (_c = ns.get(instanceNs.get("".concat(s[0], ":")))) !== null && _c !== void 0 ? _c : "".concat(s[0], ":");
        nameName = s[1];
    }
    else {
        throw new Error(name);
    }
    var nsedName = "".concat(nameNs).concat(nameName);
    var nsedSubs = subs[nameNs];
    var subsedName = nsedName;
    while (nsedSubs && !(parentMetaType === null || parentMetaType === void 0 ? void 0 : parentMetaType[subsedName])) {
        if (subsedName === undefined) {
            break;
        }
        subsedName = nsedSubs[subsedName];
    }
    return { nsedName: nsedName, subsedName: subsedName };
}
exports.resolveElement = resolveElement;
function parseInt(attrValue) {
    var i;
    try {
        i = Number.parseInt(attrValue);
    }
    catch (e) {
        throw new Error("Cannot parse integer value '".concat(attrValue, "'"));
    }
    if (Number.isNaN(i)) {
        throw new Error("Stopping NaN from propagating. Tried to parse from (integer) '".concat(attrValue, "'"));
    }
    return i;
}
function parseFloat(attrValue) {
    var f;
    try {
        f = Number.parseFloat(attrValue);
    }
    catch (e) {
        throw new Error("Cannot parse float value '".concat(attrValue, "'"));
    }
    if (Number.isNaN(f)) {
        throw new Error("Stopping NaN from propagating. Tried to parse from (float) '".concat(attrValue, "'"));
    }
    return f;
}
function parseAllNNI(attrValue) {
    try {
        return attrValue === "unbounded" ? "unbounded" : parseInt(attrValue);
    }
    catch (e) {
        throw new Error("Cannot parse allNNI value '".concat(attrValue, "'"));
    }
}
function parseBoolean(attrValue) {
    if (attrValue === "true") {
        return true;
    }
    else if (attrValue === "false") {
        return false;
    }
    else {
        throw new Error("Cannot parse boolean value '".concat(attrValue, "'"));
    }
}
var ampEntity = { regex: new RegExp("&", "g"), replacement: "&amp;" };
var gtEntity = { regex: new RegExp(">", "g"), replacement: "&gt;" };
var ltEntity = { regex: new RegExp("<", "g"), replacement: "&lt;" };
var aposEntity = { regex: new RegExp("'", "g"), replacement: "&apos;" };
var quotEntity = { regex: new RegExp("\"", "g"), replacement: "&quot;" };
function applyEntities(value) {
    return "".concat(value)
        .replace(ampEntity.regex, ampEntity.replacement)
        .replace(gtEntity.regex, gtEntity.replacement)
        .replace(ltEntity.regex, ltEntity.replacement)
        .replace(aposEntity.regex, aposEntity.replacement)
        .replace(quotEntity.regex, quotEntity.replacement);
}
function buildAttrs(json) {
    var isEmpty = true;
    var hasText = false;
    var attrs = " ";
    for (var propName in json) {
        if (propName[0] === "@") {
            attrs += "".concat(propName.substring(2), "=\"").concat(applyEntities(json[propName]), "\" ");
        }
        else if (propName === "__$$text") {
            hasText = true;
            isEmpty = false;
        }
        else if (propName !== "__$$element") {
            isEmpty = false;
        }
    }
    if (typeof json !== "object") {
        isEmpty = false;
    }
    return { attrs: attrs.substring(0, attrs.length - 1), isEmpty: isEmpty, hasText: hasText };
}
function build(args) {
    var e_2, _a, e_3, _b;
    var _c, _d;
    var json = args.json, ns = args.ns, instanceNs = args.instanceNs, indent = args.indent, metaType = args.metaType;
    if (typeof json !== "object" || json === null) {
        throw new Error("Can't build XML from a non-object value. '".concat(json, "'."));
    }
    var xml = "";
    var sortedJsonProps = [];
    for (var p in json) {
        sortedJsonProps.push(p);
    }
    var declaredPropOrder = [];
    for (var p in metaType !== null && metaType !== void 0 ? metaType : {}) {
        declaredPropOrder.push(p);
    }
    sortedJsonProps.sort(function (a, b) { return declaredPropOrder.indexOf(a) - declaredPropOrder.indexOf(b); });
    try {
        for (var sortedJsonProps_1 = __values(sortedJsonProps), sortedJsonProps_1_1 = sortedJsonProps_1.next(); !sortedJsonProps_1_1.done; sortedJsonProps_1_1 = sortedJsonProps_1.next()) {
            var __unsafeJsonPropName = sortedJsonProps_1_1.value;
            var jsonPropName = applyEntities(__unsafeJsonPropName);
            var jsonPropValue = json[jsonPropName];
            if (jsonPropName[0] === "@") {
                continue;
            }
            else if (jsonPropName === "__$$element") {
                continue;
            }
            else if (jsonPropName === "__$$text") {
                continue;
            }
            else if (jsonPropName[0] === "?") {
                xml = "".concat(indent, "<").concat(jsonPropName).concat(buildAttrs(jsonPropValue).attrs, " ?>\n") + xml;
            }
            else if (jsonPropValue === undefined || jsonPropValue === null || jsonPropValue === "") {
                var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: jsonPropName });
                xml += "".concat(indent, "<").concat(elementName, " />\n");
            }
            else if (typeof jsonPropValue !== "object") {
                var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: jsonPropName });
                xml += "".concat(indent, "<").concat(elementName, ">").concat(applyEntities(jsonPropValue), "</").concat(elementName, ">\n");
            }
            else if (Array.isArray(jsonPropValue)) {
                try {
                    for (var jsonPropValue_1 = (e_3 = void 0, __values(jsonPropValue)), jsonPropValue_1_1 = jsonPropValue_1.next(); !jsonPropValue_1_1.done; jsonPropValue_1_1 = jsonPropValue_1.next()) {
                        var item = jsonPropValue_1_1.value;
                        var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: (_c = item === null || item === void 0 ? void 0 : item["__$$element"]) !== null && _c !== void 0 ? _c : jsonPropName });
                        var _e = buildAttrs(item), attrs = _e.attrs, isEmpty = _e.isEmpty, hasText = _e.hasText;
                        xml += "".concat(indent, "<").concat(elementName).concat(attrs);
                        if (isEmpty) {
                            xml += " />\n";
                        }
                        else if (typeof item === "object") {
                            if (hasText) {
                                xml += ">".concat(applyEntities(item["__$$text"]), "</").concat(elementName, ">\n");
                            }
                            else {
                                xml += ">\n".concat(build(__assign(__assign({}, args), { json: item, metaType: getPropMetaTypeForJsonObj({ args: args, jsonObj: item, jsonPropName: jsonPropName, metaType: metaType }), indent: "".concat(indent, "  ") })));
                                xml += "".concat(indent, "</").concat(elementName, ">\n");
                            }
                        }
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (jsonPropValue_1_1 && !jsonPropValue_1_1.done && (_b = jsonPropValue_1.return)) _b.call(jsonPropValue_1);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
            else {
                var item = jsonPropValue;
                var elementName = applyInstanceNs({ ns: ns, instanceNs: instanceNs, propName: (_d = item["__$$element"]) !== null && _d !== void 0 ? _d : jsonPropName });
                var _f = buildAttrs(item), attrs = _f.attrs, isEmpty = _f.isEmpty, hasText = _f.hasText;
                xml += "".concat(indent, "<").concat(elementName).concat(attrs);
                if (isEmpty) {
                    xml += " />\n";
                }
                else if (typeof item === "object") {
                    if (hasText) {
                        xml += ">".concat(applyEntities(item["__$$text"]), "</").concat(elementName, ">\n");
                    }
                    else {
                        xml += ">\n".concat(build(__assign(__assign({}, args), { json: item, metaType: getPropMetaTypeForJsonObj({ args: args, jsonObj: item, jsonPropName: jsonPropName, metaType: metaType }), indent: "".concat(indent, "  ") })));
                        xml += "".concat(indent, "</").concat(elementName, ">\n");
                    }
                }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (sortedJsonProps_1_1 && !sortedJsonProps_1_1.done && (_a = sortedJsonProps_1.return)) _a.call(sortedJsonProps_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return xml;
}
exports.build = build;
function getPropMetaTypeForJsonObj(_a) {
    var _b, _c, _d, _e;
    var _f = _a.args, elements = _f.elements, meta = _f.meta, jsonObj = _a.jsonObj, jsonPropName = _a.jsonPropName, metaType = _a.metaType;
    return meta[(_e = (_c = elements[(_b = jsonObj === null || jsonObj === void 0 ? void 0 : jsonObj["__$$element"]) !== null && _b !== void 0 ? _b : jsonPropName]) !== null && _c !== void 0 ? _c : (_d = metaType === null || metaType === void 0 ? void 0 : metaType[jsonPropName]) === null || _d === void 0 ? void 0 : _d.type) !== null && _e !== void 0 ? _e : ""];
}
function applyInstanceNs(_a) {
    var _b, _c, _d;
    var propName = _a.propName, ns = _a.ns, instanceNs = _a.instanceNs;
    var s = propName.split(":");
    if (s.length === 1) {
        var newPropertyNs = (_b = instanceNs.get(ns.get(""))) !== null && _b !== void 0 ? _b : "";
        return "".concat(newPropertyNs).concat(propName);
    }
    else if (s.length === 2) {
        var propertyNs = "".concat(s[0], ":");
        var newPropertyNs = (_d = instanceNs.get((_c = ns.get(propertyNs)) !== null && _c !== void 0 ? _c : "obviously non-existent key")) !== null && _d !== void 0 ? _d : propertyNs;
        return "".concat(newPropertyNs).concat(s[1]);
    }
    else {
        throw new Error("Invalid tag name '".concat(propName, "'."));
    }
}
function mergeMetas(base, extensionMetasByPrefix) {
    var prefixedMetas = extensionMetasByPrefix.reduce(function (acc, _a) {
        var _b = __read(_a, 2), k = _b[0], m = _b[1];
        return __assign(__assign({}, acc), Object.keys(m).reduce(function (macc, t) {
            macc[t] = Object.keys(m[t]).reduce(function (tacc, p) {
                if (p.includes(":") || p.startsWith("@_")) {
                    tacc[p] = m[t][p];
                }
                else {
                    tacc["".concat(k).concat(p)] = m[t][p];
                }
                return tacc;
            }, {});
            return macc;
        }, {}));
    }, {});
    __spreadArray([], __read(Object.entries(prefixedMetas)), false).forEach(function (_a) {
        var _b = __read(_a, 2), k = _b[0], v = _b[1];
        base[k] = v;
    });
}
exports.mergeMetas = mergeMetas;
//# sourceMappingURL=index.js.map