"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromText = exports.toText = void 0;
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var SimplePredicateOperatorMap = new Map([
    ["equal", "="],
    ["notEqual", "<>"],
    ["lessThan", "<"],
    ["lessOrEqual", "<="],
    ["greaterThan", ">"],
    ["greaterOrEqual", ">="],
    ["isMissing", "isMissing"],
    ["isNotMissing", "isNotMissing"],
]);
var toText = function (predicate, fields) {
    var fieldToDataType = new Map(fields.map(function (field) { return [field.name, field.dataType]; }));
    return _toText(predicate, fieldToDataType, 0);
};
exports.toText = toText;
var _toText = function (predicate, fieldToDataType, nesting) {
    var _a;
    if (predicate instanceof pmml_editor_marshaller_1.True) {
        return "True";
    }
    else if (predicate instanceof pmml_editor_marshaller_1.False) {
        return "False";
    }
    else if (predicate instanceof pmml_editor_marshaller_1.SimpleSetPredicate) {
        var ssp = predicate;
        return "".concat(ssp.field.toString(), " ").concat(ssp.booleanOperator, " ").concat(ssp.Array.toString(), " ");
    }
    else if (predicate instanceof pmml_editor_marshaller_1.SimplePredicate) {
        var sp = predicate;
        return "".concat(sp.field.toString(), " ").concat(SimplePredicateOperatorMap.get(sp.operator), " ").concat(_value(sp.field, sp.value, fieldToDataType));
    }
    else if (predicate instanceof pmml_editor_marshaller_1.CompoundPredicate) {
        var cp = predicate;
        var text = "";
        var children_1 = [];
        (_a = cp.predicates) === null || _a === void 0 ? void 0 : _a.forEach(function (p) { return children_1.push(_toText(p, fieldToDataType, nesting + 1)); });
        text = text + children_1.join(" " + cp.booleanOperator + " ");
        return text;
    }
    return "";
};
var TruePredicate = function () {
    var predicate = new pmml_editor_marshaller_1.True({});
    predicate._type = "True";
    return predicate;
};
var FalsePredicate = function () {
    var predicate = new pmml_editor_marshaller_1.False({});
    predicate._type = "False";
    return predicate;
};
var UnarySimplePredicate = function (field, operator) {
    var predicate = new pmml_editor_marshaller_1.SimplePredicate({ field: field, operator: operator });
    predicate._type = "SimplePredicate";
    return predicate;
};
var BinarySimplePredicate = function (field, operator, value) {
    var predicate = new pmml_editor_marshaller_1.SimplePredicate({ field: field, operator: operator, value: value });
    predicate._type = "SimplePredicate";
    return predicate;
};
var SimpleCompoundPredicate = function (predicate1, predicate2, booleanOperator) {
    var predicate = new pmml_editor_marshaller_1.CompoundPredicate({ predicates: [predicate1, predicate2], booleanOperator: booleanOperator });
    predicate._type = "CompoundPredicate";
    return predicate;
};
var _value = function (field, value, fieldToDataType) {
    if (value === undefined) {
        return "";
    }
    var dataType = fieldToDataType.get(field);
    if (dataType === "string") {
        return "\"".concat(value, "\"");
    }
    return value.toString();
};
var _operator = function (lookup) {
    var e_1, _a;
    var lookups = SimplePredicateOperatorMap.entries();
    try {
        for (var lookups_1 = __values(lookups), lookups_1_1 = lookups_1.next(); !lookups_1_1.done; lookups_1_1 = lookups_1.next()) {
            var _b = __read(lookups_1_1.value, 2), pmmlOperator = _b[0], operator = _b[1];
            if (operator === lookup) {
                return pmmlOperator;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (lookups_1_1 && !lookups_1_1.done && (_a = lookups_1.return)) _a.call(lookups_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
var fromText = function (text) {
    if (text === undefined) {
        return undefined;
    }
    text = text.trim();
    if (text === "") {
        return undefined;
    }
    var regTrue = /^True$/gim;
    var regFalse = /^False$/gim;
    var regUnaryOperator = /^(\S+)\s+(isMissing|isNotMissing)\s*$/gm;
    var regBinaryOperator = /^(\S+)\s*(=|>|<|<=|>=|<>)\s*"?(\S+)"?$/gm;
    var regSimpleCompound = /^(.*)\s*(\band\b|\bxor\b|\bor\b)\s*(.*)$/gm;
    if (regTrue.test(text)) {
        return TruePredicate();
    }
    if (regFalse.test(text)) {
        return FalsePredicate();
    }
    var unaryMatches = regUnaryOperator.exec(text);
    if (unaryMatches !== null) {
        return UnarySimplePredicate(unaryMatches[1], unaryMatches[2]);
    }
    var binaryMatches = regBinaryOperator.exec(text);
    if (binaryMatches !== null) {
        return BinarySimplePredicate(binaryMatches[1], _operator(binaryMatches[2]), binaryMatches[3]);
    }
    var compoundMatches = regSimpleCompound.exec(text);
    if (compoundMatches !== null) {
        var predicate1 = (0, exports.fromText)(compoundMatches[1]);
        var predicate2 = (0, exports.fromText)(compoundMatches[3]);
        var booleanOperator = compoundMatches[2];
        if (predicate1 !== undefined && predicate2 !== undefined && booleanOperator !== undefined) {
            return SimpleCompoundPredicate(predicate1, predicate2, booleanOperator);
        }
    }
    return TruePredicate();
};
exports.fromText = fromText;
//# sourceMappingURL=PredicateConverter.js.map