"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributesReducer = void 0;
var Actions_1 = require("./Actions");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var immer_1 = require("immer");
var paths_1 = require("../paths");
pmml_editor_marshaller_1.Attribute[immer_1.immerable] = true;
pmml_editor_marshaller_1.Predicate[immer_1.immerable] = true;
pmml_editor_marshaller_1.SimplePredicate[immer_1.immerable] = true;
pmml_editor_marshaller_1.CompoundPredicate[immer_1.immerable] = true;
var AttributesReducer = function (historyService) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.Scorecard_AddAttribute:
                historyService.batch(state, (0, paths_1.Builder)()
                    .forModel(action.payload.modelIndex)
                    .forCharacteristics()
                    .forCharacteristic(action.payload.characteristicIndex)
                    .forAttribute()
                    .build(), function (draft) {
                    draft.push({
                        predicate: action.payload.predicate,
                        partialScore: action.payload.partialScore,
                        reasonCode: action.payload.reasonCode,
                    });
                });
                break;
            case Actions_1.Actions.Scorecard_DeleteAttribute:
                historyService.batch(state, (0, paths_1.Builder)()
                    .forModel(action.payload.modelIndex)
                    .forCharacteristics()
                    .forCharacteristic(action.payload.characteristicIndex)
                    .forAttribute()
                    .build(), function (draft) {
                    var attributeIndex = action.payload.attributeIndex;
                    if (attributeIndex >= 0 && attributeIndex < draft.length) {
                        draft.splice(attributeIndex, 1);
                    }
                });
                break;
            case Actions_1.Actions.Scorecard_UpdateAttribute:
                historyService.batch(state, (0, paths_1.Builder)()
                    .forModel(action.payload.modelIndex)
                    .forCharacteristics()
                    .forCharacteristic(action.payload.characteristicIndex)
                    .forAttribute()
                    .build(), function (draft) {
                    var attributeIndex = action.payload.attributeIndex;
                    if (attributeIndex >= 0 && attributeIndex < draft.length) {
                        draft[attributeIndex] = __assign(__assign({}, draft[attributeIndex]), { predicate: action.payload.predicate, partialScore: action.payload.partialScore, reasonCode: action.payload.reasonCode });
                    }
                });
        }
        return state;
    };
};
exports.AttributesReducer = AttributesReducer;
//# sourceMappingURL=AttributesReducer.js.map