"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.explorerFolder = exports.inputBox = exports.kogitoLoadingSpinner = exports.envelopeApp = exports.activeFrame = exports.webViewReady = void 0;
var vscode_extension_tester_1 = require("vscode-extension-tester");
var webViewReady = function () {
    return vscode_extension_tester_1.By.className("webview ready");
};
exports.webViewReady = webViewReady;
var activeFrame = function () {
    return vscode_extension_tester_1.By.id("active-frame");
};
exports.activeFrame = activeFrame;
var envelopeApp = function () {
    return vscode_extension_tester_1.By.id("envelope-app");
};
exports.envelopeApp = envelopeApp;
var kogitoLoadingSpinner = function () {
    return vscode_extension_tester_1.By.className("kie-tools--loading-screen-spinner");
};
exports.kogitoLoadingSpinner = kogitoLoadingSpinner;
var inputBox = function () {
    return vscode_extension_tester_1.By.xpath('.//input[@type="text"]');
};
exports.inputBox = inputBox;
var explorerFolder = function (folderName) {
    return vscode_extension_tester_1.By.xpath("//div[contains(@class, \"monaco-list-row\") and @aria-label=\"".concat(folderName, "\"]"));
};
exports.explorerFolder = explorerFolder;
//# sourceMappingURL=CommonLocators.js.map