"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashbuilderYamlCodeCompletionStrategy = exports.DashbuilderYamlLanguageService = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var yaml_language_server_parser_1 = require("yaml-language-server-parser");
var api_1 = require("../api");
var schemas_1 = require("../assets/schemas");
var DashbuilderLanguageService_1 = require("./DashbuilderLanguageService");
var DashbuilderYamlLanguageService = (function () {
    function DashbuilderYamlLanguageService() {
        this.ls = new DashbuilderLanguageService_1.DashbuilderLanguageService({
            fs: {},
            lang: {
                fileLanguage: api_1.FileLanguage.YAML,
                fileMatch: ["*.dash.yaml", "*.dash.yml"],
            },
        });
        this.codeCompletionStrategy = new DashbuilderYamlCodeCompletionStrategy();
        this.yamlELs = new channel_1.EditorYamlLanguageService({
            ls: this.ls,
            codeCompletionStrategy: this.codeCompletionStrategy,
        });
    }
    DashbuilderYamlLanguageService.prototype.getCompletionItems = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.yamlELs.getCompletionItems(args)];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    DashbuilderYamlLanguageService.prototype.getCodeLenses = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.yamlELs.getCodeLenses(args)];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    DashbuilderYamlLanguageService.prototype.getDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.yamlELs.getDiagnostics(__assign(__assign({}, args), { getSchemaDiagnostics: function (args) {
                                return _this.getSchemaDiagnostics(args);
                            } }))];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    DashbuilderYamlLanguageService.prototype.getSchemaDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.yamlELs.getSchemaDiagnostics(__assign(__assign({}, args), { jsonSchema: schemas_1.DASHBUILDER_SCHEMA }))];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    DashbuilderYamlLanguageService.prototype.dispose = function () {
        return this.yamlELs.dispose();
    };
    return DashbuilderYamlLanguageService;
}());
exports.DashbuilderYamlLanguageService = DashbuilderYamlLanguageService;
var DashbuilderYamlCodeCompletionStrategy = (function () {
    function DashbuilderYamlCodeCompletionStrategy() {
        this.eLsCodeCompletionStrategy = new channel_1.EditorYamlCodeCompletionStrategy();
    }
    DashbuilderYamlCodeCompletionStrategy.prototype.translate = function (args) {
        var _a, _b, _c, _d;
        var completionDump = (0, yaml_language_server_parser_1.dump)(args.completion, {}).slice(2, -1).trim();
        if (["{}", "[]"].includes(completionDump) || args.completionItemKind === vscode_languageserver_types_1.CompletionItemKind.Text) {
            return completionDump;
        }
        var skipFirstLineIndent = args.completionItemKind !== vscode_languageserver_types_1.CompletionItemKind.Module;
        var completionItemNewLine = args.completionItemKind === vscode_languageserver_types_1.CompletionItemKind.Module ? "\n" : "";
        var completionText = completionItemNewLine + (0, channel_1.indentText)(completionDump, 2, " ", skipFirstLineIndent);
        return [vscode_languageserver_types_1.CompletionItemKind.Interface, vscode_languageserver_types_1.CompletionItemKind.Reference].includes(args.completionItemKind) && (0, channel_1.positions_equals)((_b = (_a = args.overwriteRange) === null || _a === void 0 ? void 0 : _a.start) !== null && _b !== void 0 ? _b : null, (_d = (_c = args.currentNodeRange) === null || _c === void 0 ? void 0 : _c.start) !== null && _d !== void 0 ? _d : null)
            ? "- ".concat(completionText, "\n")
            : completionText;
    };
    DashbuilderYamlCodeCompletionStrategy.prototype.formatLabel = function (label, completionItemKind) {
        return this.eLsCodeCompletionStrategy.formatLabel(label, completionItemKind);
    };
    DashbuilderYamlCodeCompletionStrategy.prototype.getStartNodeValuePosition = function (document, node) {
        return this.eLsCodeCompletionStrategy.getStartNodeValuePosition(document, node);
    };
    DashbuilderYamlCodeCompletionStrategy.prototype.shouldComplete = function (args) {
        return this.eLsCodeCompletionStrategy.shouldComplete(args);
    };
    DashbuilderYamlCodeCompletionStrategy.prototype.shouldCreateCodelens = function (args) {
        return this.eLsCodeCompletionStrategy.shouldCreateCodelens(args);
    };
    return DashbuilderYamlCodeCompletionStrategy;
}());
exports.DashbuilderYamlCodeCompletionStrategy = DashbuilderYamlCodeCompletionStrategy;
//# sourceMappingURL=DashbuilderYamlLanguageService.js.map