/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeactivateTemplatePlan
extends PhysicalPlan {
    String templateName;
    PartialPath prefixPath;
    transient List<PartialPath> pathToDeactivate;

    public DeactivateTemplatePlan() {
        super(Operator.OperatorType.DEACTIVATE_TEMPLATE);
    }

    public DeactivateTemplatePlan(String templateName, PartialPath prefixPath) {
        super(Operator.OperatorType.DEACTIVATE_TEMPLATE);
        this.templateName = templateName;
        this.prefixPath = prefixPath;
        this.pathToDeactivate = null;
    }

    public DeactivateTemplatePlan(String templateName, String prefixPath) throws IllegalPathException {
        super(Operator.OperatorType.DEACTIVATE_TEMPLATE);
        this.templateName = templateName;
        this.prefixPath = new PartialPath(prefixPath);
        this.pathToDeactivate = null;
    }

    public List<PartialPath> getPaths() {
        return this.pathToDeactivate;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.pathToDeactivate = paths;
    }

    @Override
    public List<? extends PartialPath> getAuthPaths() {
        return Collections.singletonList(this.prefixPath);
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.DEACTIVATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.templateName, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.prefixPath.getFullPath(), (ByteBuffer)buffer);
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.templateName = this.readString(buffer);
        this.prefixPath = new PartialPath(this.readString(buffer));
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.DEACTIVATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.templateName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.prefixPath.getFullPath(), (OutputStream)stream);
        stream.writeLong(this.index);
    }
}

