/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class SetTTLPlan
extends PhysicalPlan {
    private PartialPath storageGroup;
    private long dataTTL;

    public SetTTLPlan() {
        super(Operator.OperatorType.TTL);
    }

    public SetTTLPlan(PartialPath storageGroup, long dataTTL) {
        super(Operator.OperatorType.TTL);
        this.storageGroup = storageGroup;
        this.dataTTL = dataTTL;
    }

    public SetTTLPlan(PartialPath storageGroup) {
        this(storageGroup, Long.MAX_VALUE);
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.TTL.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.dataTTL);
        this.putString(stream, this.storageGroup.getFullPath());
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.TTL.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.dataTTL);
        this.putString(buffer, this.storageGroup.getFullPath());
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.dataTTL = buffer.getLong();
        this.storageGroup = new PartialPath(this.readString(buffer));
        this.index = buffer.getLong();
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(PartialPath storageGroup) {
        this.storageGroup = storageGroup;
    }

    public long getDataTTL() {
        return this.dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }
}

