/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.applier;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.logtypes.CloseFileLog;
import org.apache.iotdb.cluster.log.logtypes.PhysicalPlanLog;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataLogApplier
implements LogApplier {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDataLogApplier.class);
    private static final int CONCURRENT_CONSUMER_NUM = Runtime.getRuntime().availableProcessors();
    private LogApplier embeddedApplier;
    private Map<PartialPath, DataLogConsumer> consumerMap;
    private ExecutorService consumerPool;
    private String name;
    private final Object consumerEmptyCondition = new Object();

    public AsyncDataLogApplier(LogApplier embeddedApplier, String name) {
        this.embeddedApplier = embeddedApplier;
        this.consumerMap = new HashMap<PartialPath, DataLogConsumer>();
        this.consumerPool = new ThreadPoolExecutor(CONCURRENT_CONSUMER_NUM, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.name = name;
    }

    @Override
    public void close() {
        this.consumerPool.shutdownNow();
    }

    @Override
    public synchronized void apply(Log log) {
        PartialPath logKey;
        try {
            logKey = this.getLogKey(log);
        }
        catch (StorageGroupNotSetException e) {
            logger.debug("Exception occurred when applying {}", (Object)log, (Object)e);
            log.setException((Exception)((Object)e));
            log.setApplied(true);
            return;
        }
        if (logKey != null) {
            long startTime = Timer.Statistic.RAFT_SENDER_COMMIT_TO_CONSUMER_LOGS.getOperationStartTime();
            this.provideLogToConsumers(logKey, log);
            Timer.Statistic.RAFT_SENDER_COMMIT_TO_CONSUMER_LOGS.calOperationCostTimeFromStart(startTime);
            return;
        }
        logger.debug("{}: {} is waiting for consumers to drain", (Object)this.name, (Object)log);
        long startTime = Timer.Statistic.RAFT_SENDER_COMMIT_EXCLUSIVE_LOGS.getOperationStartTime();
        this.drainConsumers();
        this.applyInternal(log);
        Timer.Statistic.RAFT_SENDER_COMMIT_EXCLUSIVE_LOGS.calOperationCostTimeFromStart(startTime);
    }

    private PartialPath getLogKey(Log log) throws StorageGroupNotSetException {
        if (log instanceof PhysicalPlanLog) {
            PhysicalPlanLog physicalPlanLog = (PhysicalPlanLog)log;
            PhysicalPlan plan = physicalPlanLog.getPlan();
            return this.getPlanKey(plan);
        }
        if (log instanceof CloseFileLog) {
            CloseFileLog closeFileLog = (CloseFileLog)log;
            PartialPath partialPath = null;
            try {
                partialPath = new PartialPath(closeFileLog.getStorageGroupName());
            }
            catch (IllegalPathException illegalPathException) {
                // empty catch block
            }
            return partialPath;
        }
        return null;
    }

    private PartialPath getPlanKey(PhysicalPlan plan) throws StorageGroupNotSetException {
        return this.getPlanSG(plan);
    }

    private PartialPath getPlanSG(PhysicalPlan plan) throws StorageGroupNotSetException {
        PartialPath sgPath = null;
        if (plan instanceof InsertMultiTabletPlan) {
            PartialPath deviceId = ((InsertMultiTabletPlan)plan).getFirstDeviceId();
            sgPath = IoTDB.metaManager.getBelongedStorageGroup(deviceId);
        } else if (plan instanceof InsertRowsPlan) {
            PartialPath path = ((InsertRowsPlan)plan).getFirstDeviceId();
            sgPath = IoTDB.metaManager.getBelongedStorageGroup(path);
        } else if (plan instanceof InsertPlan) {
            PartialPath deviceId = ((InsertPlan)plan).getDevicePath();
            sgPath = IoTDB.metaManager.getBelongedStorageGroup(deviceId);
        } else if (plan instanceof CreateTimeSeriesPlan) {
            PartialPath path = ((CreateTimeSeriesPlan)plan).getPath();
            sgPath = IoTDB.metaManager.getBelongedStorageGroup(path);
        }
        return sgPath;
    }

    private void provideLogToConsumers(PartialPath planKey, Log log) {
        log.setEnqueueTime(System.nanoTime());
        this.consumerMap.computeIfAbsent(planKey, d -> new DataLogConsumer(this.name + "-" + d)).accept(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainConsumers() {
        Object object = this.consumerEmptyCondition;
        synchronized (object) {
            while (!this.allConsumersEmpty()) {
                try {
                    this.consumerEmptyCondition.wait(5L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private boolean allConsumersEmpty() {
        for (DataLogConsumer consumer : this.consumerMap.values()) {
            if (consumer.isEmpty()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Consumer not empty: {}", (Object)consumer);
            }
            return false;
        }
        return true;
    }

    private void applyInternal(Log log) {
        long startTime = Timer.Statistic.RAFT_SENDER_DATA_LOG_APPLY.getOperationStartTime();
        this.embeddedApplier.apply(log);
        Timer.Statistic.RAFT_SENDER_DATA_LOG_APPLY.calOperationCostTimeFromStart(startTime);
    }

    private class DataLogConsumer
    implements Runnable,
    Consumer<Log> {
        private BlockingQueue<Log> logQueue = new ArrayBlockingQueue<Log>(4096);
        private volatile long lastLogIndex;
        private volatile long lastAppliedLogIndex;
        private String name;
        private Future<?> future;

        public DataLogConsumer(String name) {
            this.name = name;
        }

        public boolean isEmpty() {
            return this.lastLogIndex == this.lastAppliedLogIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setPriority(8);
            Thread.currentThread().setName(this.name);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Log log = this.logQueue.take();
                    Timer.Statistic.RAFT_SENDER_IN_APPLY_QUEUE.calOperationCostTimeFromStart(log.getEnqueueTime());
                    try {
                        AsyncDataLogApplier.this.applyInternal(log);
                    }
                    finally {
                        this.lastAppliedLogIndex = log.getCurrLogIndex();
                        if (!this.isEmpty()) continue;
                        Object object = AsyncDataLogApplier.this.consumerEmptyCondition;
                        synchronized (object) {
                            AsyncDataLogApplier.this.consumerEmptyCondition.notifyAll();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    logger.error("DataLogConsumer exits", (Throwable)e);
                    return;
                }
            }
            logger.info("DataLogConsumer exits");
        }

        @Override
        public void accept(Log log) {
            if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
                if (this.future != null) {
                    try {
                        this.future.get();
                    }
                    catch (InterruptedException e) {
                        logger.error("Last applier thread exits unexpectedly", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        logger.error("Last applier thread exits unexpectedly", (Throwable)e);
                    }
                }
                this.future = AsyncDataLogApplier.this.consumerPool.submit(this);
            }
            try {
                this.lastLogIndex = log.getCurrLogIndex();
                this.logQueue.put(log);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.setException(e);
                log.setApplied(true);
                this.lastAppliedLogIndex = log.getCurrLogIndex();
            }
        }

        public String toString() {
            return "DataLogConsumer{logQueue=" + this.logQueue.size() + ", lastLogIndex=" + this.lastLogIndex + ", lastAppliedLogIndex=" + this.lastAppliedLogIndex + ", name='" + this.name + '\'' + '}';
        }
    }
}

