/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.EmptyIntervalException;
import org.apache.iotdb.cluster.exception.RequestTimeOutException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.query.LocalQueryExecutor;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.query.filter.SlotTsFileFilter;
import org.apache.iotdb.cluster.query.groupby.RemoteGroupByExecutor;
import org.apache.iotdb.cluster.query.manage.QueryCoordinator;
import org.apache.iotdb.cluster.query.reader.DataSourceInfo;
import org.apache.iotdb.cluster.query.reader.EmptyReader;
import org.apache.iotdb.cluster.query.reader.ManagedDescPriorityMergeReader;
import org.apache.iotdb.cluster.query.reader.ManagedPriorityMergeReader;
import org.apache.iotdb.cluster.query.reader.MergedReaderByTime;
import org.apache.iotdb.cluster.query.reader.RemoteSeriesReaderByTimestamp;
import org.apache.iotdb.cluster.query.reader.RemoteSimpleSeriesReader;
import org.apache.iotdb.cluster.query.reader.mult.AbstractMultPointReader;
import org.apache.iotdb.cluster.query.reader.mult.MultBatchReader;
import org.apache.iotdb.cluster.query.reader.mult.MultDataSourceInfo;
import org.apache.iotdb.cluster.query.reader.mult.MultEmptyReader;
import org.apache.iotdb.cluster.query.reader.mult.MultSeriesRawDataPointReader;
import org.apache.iotdb.cluster.query.reader.mult.RemoteMultSeriesReader;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.utils.ClusterQueryUtils;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.externalsort.adapter.ByTimestampReaderAdapter;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataPointReader;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterReaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClusterReaderFactory.class);
    private final MetaGroupMember metaGroupMember;

    public ClusterReaderFactory(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    public void syncMetaGroup() throws CheckConsistencyException {
        this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
    }

    public IReaderByTimestamp getReaderByTimestamp(PartialPath path, Set<String> deviceMeasurements, TSDataType dataType, QueryContext context, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException, QueryProcessException {
        List<PartitionGroup> partitionGroups;
        try {
            partitionGroups = this.metaGroupMember.routeFilter(null, path);
        }
        catch (EmptyIntervalException e) {
            logger.warn(e.getMessage());
            partitionGroups = Collections.emptyList();
        }
        logger.debug("{}: Sending query of {} to {} groups", new Object[]{this.metaGroupMember.getName(), path, partitionGroups.size()});
        ArrayList<IReaderByTimestamp> readers = new ArrayList<IReaderByTimestamp>(partitionGroups.size());
        for (PartitionGroup partitionGroup : partitionGroups) {
            IReaderByTimestamp readerByTimestamp = this.getSeriesReaderByTime(partitionGroup, path, deviceMeasurements, context, dataType, ascending, requiredSlots);
            readers.add(readerByTimestamp);
        }
        return new MergedReaderByTime(readers);
    }

    private IReaderByTimestamp getSeriesReaderByTime(PartitionGroup partitionGroup, PartialPath path, Set<String> deviceMeasurements, QueryContext context, TSDataType dataType, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException, QueryProcessException {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            DataGroupMember dataGroupMember = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), partitionGroup.getRaftId());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: creating a local reader for {}#{}", new Object[]{this.metaGroupMember.getName(), path.getFullPath(), context.getQueryId()});
            }
            return this.getReaderByTimestamp(path, deviceMeasurements, dataType, context, dataGroupMember, ascending, requiredSlots);
        }
        return this.getRemoteReaderByTimestamp((Path)path, deviceMeasurements, dataType, partitionGroup, context, ascending, requiredSlots);
    }

    private IReaderByTimestamp getRemoteReaderByTimestamp(Path path, Set<String> deviceMeasurements, TSDataType dataType, PartitionGroup partitionGroup, QueryContext context, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException {
        List<Node> reorderedNodes;
        SingleSeriesQueryRequest request = this.constructSingleQueryRequest(null, null, dataType, path, deviceMeasurements, partitionGroup, context, ascending, requiredSlots);
        DataSourceInfo dataSourceInfo = new DataSourceInfo(partitionGroup, dataType, request, (RemoteQueryContext)context, reorderedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup));
        boolean hasClient = dataSourceInfo.hasNextDataClient(true, Long.MIN_VALUE);
        if (hasClient) {
            return new RemoteSeriesReaderByTimestamp(dataSourceInfo);
        }
        if (dataSourceInfo.isNoData()) {
            return new EmptyReader();
        }
        throw new StorageEngineException((Throwable)new RequestTimeOutException("Query by timestamp: " + path + " in " + partitionGroup));
    }

    public List<AbstractMultPointReader> getMultSeriesReader(List<PartialPath> paths, Map<String, Set<String>> deviceMeasurements, List<TSDataType> dataTypes, Filter timeFilter, Filter valueFilter, QueryContext context, boolean ascending) throws StorageEngineException, EmptyIntervalException, QueryProcessException {
        HashMap partitionGroupListMap = Maps.newHashMap();
        for (PartialPath partialPath2 : paths) {
            List<PartitionGroup> partitionGroups = this.metaGroupMember.routeFilter(timeFilter, partialPath2);
            partitionGroups.forEach(partitionGroup -> partitionGroupListMap.computeIfAbsent(partitionGroup, n -> new ArrayList()).add(partialPath2));
        }
        ArrayList multPointReaders = Lists.newArrayList();
        for (Map.Entry entityPartitionGroup : partitionGroupListMap.entrySet()) {
            List partialPaths = (List)entityPartitionGroup.getValue();
            HashMap partitionGroupDeviceMeasurements = Maps.newHashMap();
            ArrayList partitionGroupTSDataType = Lists.newArrayList();
            partialPaths.forEach(partialPath -> {
                Set measurements = deviceMeasurements.getOrDefault(partialPath.getDevice(), Collections.emptySet());
                partitionGroupDeviceMeasurements.put(partialPath.getFullPath(), measurements);
                partitionGroupTSDataType.add((TSDataType)dataTypes.get(paths.lastIndexOf(partialPath)));
            });
            AbstractMultPointReader abstractMultPointReader = this.getMultSeriesReader((PartitionGroup)entityPartitionGroup.getKey(), partialPaths, partitionGroupTSDataType, partitionGroupDeviceMeasurements, timeFilter, valueFilter, context, ascending);
            multPointReaders.add(abstractMultPointReader);
        }
        return multPointReaders;
    }

    private AbstractMultPointReader getMultSeriesReader(PartitionGroup partitionGroup, List<PartialPath> partialPaths, List<TSDataType> dataTypes, Map<String, Set<String>> deviceMeasurements, Filter timeFilter, Filter valueFilter, QueryContext context, boolean ascending) throws StorageEngineException, QueryProcessException {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            DataGroupMember dataGroupMember = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), String.format("Query: %s, time filter: %s, queryId: %d", partialPaths, timeFilter, context.getQueryId()));
            HashMap partialPathPointReaderMap = Maps.newHashMap();
            for (int i = 0; i < partialPaths.size(); ++i) {
                PartialPath partialPath = partialPaths.get(i);
                IPointReader seriesPointReader = this.getSeriesPointReader(partialPath, deviceMeasurements.get(partialPath.getFullPath()), dataTypes.get(i), timeFilter, valueFilter, context, dataGroupMember, ascending, null);
                partialPathPointReaderMap.put(partialPath.getFullPath(), seriesPointReader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: creating a local reader for {}#{} of {}", new Object[]{this.metaGroupMember.getName(), partialPaths, context.getQueryId(), partitionGroup.getHeader()});
            }
            return new MultSeriesRawDataPointReader(partialPathPointReaderMap);
        }
        return this.getRemoteMultSeriesPointReader(timeFilter, valueFilter, dataTypes, partialPaths, deviceMeasurements, partitionGroup, context, ascending);
    }

    public ManagedSeriesReader getSeriesReader(PartialPath path, Set<String> deviceMeasurements, TSDataType dataType, Filter timeFilter, Filter valueFilter, QueryContext context, boolean ascending) throws StorageEngineException, EmptyIntervalException {
        List<PartitionGroup> partitionGroups = this.metaGroupMember.routeFilter(timeFilter, path);
        logger.debug("{}: Sending data query of {} to {} groups", new Object[]{this.metaGroupMember.getName(), path, partitionGroups.size()});
        ManagedSeriesReader mergeReader = ascending ? new ManagedPriorityMergeReader(dataType) : new ManagedDescPriorityMergeReader(dataType);
        try {
            for (PartitionGroup partitionGroup : partitionGroups) {
                IPointReader seriesReader = this.getSeriesReader(partitionGroup, path, deviceMeasurements, timeFilter, valueFilter, context, dataType, ascending, null);
                mergeReader.addReader(seriesReader, 0L);
            }
        }
        catch (IOException | QueryProcessException e) {
            throw new StorageEngineException(e);
        }
        return mergeReader;
    }

    private IPointReader getSeriesReader(PartitionGroup partitionGroup, PartialPath path, Set<String> deviceMeasurements, Filter timeFilter, Filter valueFilter, QueryContext context, TSDataType dataType, boolean ascending, Set<Integer> requiredSlots) throws IOException, StorageEngineException, QueryProcessException {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            DataGroupMember dataGroupMember = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), String.format("Query: %s, time filter: %s, queryId: %d", path, timeFilter, context.getQueryId()));
            IPointReader seriesPointReader = this.getSeriesPointReader(path, deviceMeasurements, dataType, timeFilter, valueFilter, context, dataGroupMember, ascending, requiredSlots);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: creating a local reader for {}#{} of {}, empty: {}", new Object[]{this.metaGroupMember.getName(), path.getFullPath(), context.getQueryId(), partitionGroup.getHeader(), !seriesPointReader.hasNextTimeValuePair()});
            }
            return seriesPointReader;
        }
        return this.getRemoteSeriesPointReader(timeFilter, valueFilter, dataType, (Path)path, deviceMeasurements, partitionGroup, context, ascending, requiredSlots);
    }

    public IPointReader getSeriesPointReader(PartialPath path, Set<String> allSensors, TSDataType dataType, Filter timeFilter, Filter valueFilter, QueryContext context, DataGroupMember dataGroupMember, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException, QueryProcessException {
        try {
            dataGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        return new SeriesRawDataPointReader(this.getSeriesReader(path, allSensors, dataType, timeFilter, valueFilter, context, dataGroupMember.getHeader(), ascending, requiredSlots));
    }

    private SeriesReader getSeriesReader(PartialPath path, Set<String> allSensors, TSDataType dataType, Filter timeFilter, Filter valueFilter, QueryContext context, RaftNode header, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException, QueryProcessException {
        if (requiredSlots == null) {
            List<Integer> nodeSlots = ((SlotPartitionTable)this.metaGroupMember.getPartitionTable()).getNodeSlots(header);
            requiredSlots = new HashSet<Integer>(nodeSlots);
        }
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter, ascending);
        valueFilter = queryDataSource.updateFilterUsingTTL(valueFilter);
        return path.createSeriesReader(allSensors, dataType, context, queryDataSource, timeFilter, valueFilter, (TsFileFilter)new SlotTsFileFilter(requiredSlots), ascending);
    }

    private AbstractMultPointReader getRemoteMultSeriesPointReader(Filter timeFilter, Filter valueFilter, List<TSDataType> dataType, List<PartialPath> paths, Map<String, Set<String>> deviceMeasurements, PartitionGroup partitionGroup, QueryContext context, boolean ascending) throws StorageEngineException {
        List<Node> orderedNodes;
        MultSeriesQueryRequest request = this.constructMultQueryRequest(timeFilter, valueFilter, dataType, paths, deviceMeasurements, partitionGroup, context, ascending);
        MultDataSourceInfo dataSourceInfo = new MultDataSourceInfo(partitionGroup, paths, dataType, request, (RemoteQueryContext)context, orderedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup));
        boolean hasClient = dataSourceInfo.hasNextDataClient(Long.MIN_VALUE);
        if (hasClient) {
            return new RemoteMultSeriesReader(dataSourceInfo);
        }
        if (dataSourceInfo.isNoData()) {
            HashSet fullPaths = Sets.newHashSet();
            dataSourceInfo.getPartialPaths().forEach(partialPath -> fullPaths.add(partialPath.getFullPath()));
            return new MultEmptyReader(fullPaths);
        }
        throw new StorageEngineException((Throwable)new RequestTimeOutException("Query multi-series: " + paths + " in " + partitionGroup));
    }

    private IPointReader getRemoteSeriesPointReader(Filter timeFilter, Filter valueFilter, TSDataType dataType, Path path, Set<String> deviceMeasurements, PartitionGroup partitionGroup, QueryContext context, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException {
        List<Node> orderedNodes;
        SingleSeriesQueryRequest request = this.constructSingleQueryRequest(timeFilter, valueFilter, dataType, path, deviceMeasurements, partitionGroup, context, ascending, requiredSlots);
        DataSourceInfo dataSourceInfo = new DataSourceInfo(partitionGroup, dataType, request, (RemoteQueryContext)context, orderedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup));
        boolean hasClient = dataSourceInfo.hasNextDataClient(false, Long.MIN_VALUE);
        if (hasClient) {
            return new RemoteSimpleSeriesReader(dataSourceInfo);
        }
        if (dataSourceInfo.isNoData()) {
            return new EmptyReader();
        }
        throw new StorageEngineException((Throwable)new RequestTimeOutException("Query " + path + " in " + partitionGroup));
    }

    private MultSeriesQueryRequest constructMultQueryRequest(Filter timeFilter, Filter valueFilter, List<TSDataType> dataTypes, List<PartialPath> paths, Map<String, Set<String>> deviceMeasurements, PartitionGroup partitionGroup, QueryContext context, boolean ascending) {
        MultSeriesQueryRequest request = new MultSeriesQueryRequest();
        if (timeFilter != null) {
            request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)timeFilter));
        }
        if (valueFilter != null) {
            request.setValueFilterBytes(SerializeUtils.serializeFilter((Filter)valueFilter));
        }
        ArrayList fullPaths = Lists.newArrayList();
        paths.forEach(path -> fullPaths.add(ClusterQueryUtils.getPathStrListForRequest((Path)path)));
        ArrayList dataTypeOrdinals = Lists.newArrayList();
        dataTypes.forEach(dataType -> dataTypeOrdinals.add(dataType.ordinal()));
        request.setPath((List)fullPaths);
        request.setHeader(partitionGroup.getHeader());
        request.setQueryId(context.getQueryId());
        request.setRequester(this.metaGroupMember.getThisNode());
        request.setDataTypeOrdinal((List)dataTypeOrdinals);
        request.setDeviceMeasurements(deviceMeasurements);
        request.setAscending(ascending);
        return request;
    }

    private SingleSeriesQueryRequest constructSingleQueryRequest(Filter timeFilter, Filter valueFilter, TSDataType dataType, Path path, Set<String> deviceMeasurements, PartitionGroup partitionGroup, QueryContext context, boolean ascending, Set<Integer> requiredSlots) {
        SingleSeriesQueryRequest request = new SingleSeriesQueryRequest();
        if (timeFilter != null) {
            request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)timeFilter));
        }
        if (valueFilter != null) {
            request.setValueFilterBytes(SerializeUtils.serializeFilter((Filter)valueFilter));
        }
        request.setPath(ClusterQueryUtils.getPathStrListForRequest(path));
        request.setHeader(partitionGroup.getHeader());
        request.setQueryId(context.getQueryId());
        request.setRequester(this.metaGroupMember.getThisNode());
        request.setDataTypeOrdinal(dataType.ordinal());
        request.setDeviceMeasurements(deviceMeasurements);
        request.setAscending(ascending);
        request.setRequiredSlots(requiredSlots);
        return request;
    }

    public List<GroupByExecutor> getGroupByExecutors(PartialPath path, Set<String> deviceMeasurements, TSDataType dataType, QueryContext context, Filter timeFilter, List<Integer> aggregationTypes, boolean ascending) throws StorageEngineException, QueryProcessException {
        List<PartitionGroup> partitionGroups;
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new QueryProcessException(e.getMessage());
        }
        try {
            partitionGroups = this.metaGroupMember.routeFilter(timeFilter, path);
        }
        catch (EmptyIntervalException e) {
            logger.info(e.getMessage());
            partitionGroups = Collections.emptyList();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending group by query of {} to {} groups", new Object[]{this.metaGroupMember.getName(), path, partitionGroups.size()});
        }
        ArrayList<GroupByExecutor> executors = new ArrayList<GroupByExecutor>();
        for (PartitionGroup partitionGroup : partitionGroups) {
            GroupByExecutor groupByExecutor = this.getGroupByExecutor(path, deviceMeasurements, partitionGroup, timeFilter, context, dataType, aggregationTypes, ascending);
            executors.add(groupByExecutor);
        }
        return executors;
    }

    private GroupByExecutor getGroupByExecutor(PartialPath path, Set<String> deviceMeasurements, PartitionGroup partitionGroup, Filter timeFilter, QueryContext context, TSDataType dataType, List<Integer> aggregationTypes, boolean ascending) throws StorageEngineException, QueryProcessException {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            DataGroupMember dataGroupMember = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), partitionGroup.getRaftId());
            LocalQueryExecutor localQueryExecutor = new LocalQueryExecutor(dataGroupMember);
            logger.debug("{}: creating a local group by executor for {}#{}", new Object[]{this.metaGroupMember.getName(), path.getFullPath(), context.getQueryId()});
            return localQueryExecutor.getGroupByExecutor(path, deviceMeasurements, dataType, timeFilter, aggregationTypes, context, ascending);
        }
        return this.getRemoteGroupByExecutor(timeFilter, aggregationTypes, dataType, (Path)path, deviceMeasurements, partitionGroup, context, ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupByExecutor getRemoteGroupByExecutor(Filter timeFilter, List<Integer> aggregationTypes, TSDataType dataType, Path path, Set<String> deviceMeasurements, PartitionGroup partitionGroup, QueryContext context, boolean ascending) throws StorageEngineException {
        GroupByRequest request = new GroupByRequest();
        if (timeFilter != null) {
            request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)timeFilter));
        }
        request.setPath(path.getFullPath());
        request.setHeader(partitionGroup.getHeader());
        request.setQueryId(context.getQueryId());
        request.setAggregationTypeOrdinals(aggregationTypes);
        request.setDataTypeOrdinal(dataType.ordinal());
        request.setRequestor(this.metaGroupMember.getThisNode());
        request.setDeviceMeasurements(deviceMeasurements);
        request.setAscending(ascending);
        List<Node> orderedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : orderedNodes) {
            logger.debug("{}: querying group by {} from {}", new Object[]{this.metaGroupMember.getName(), path, node});
            try {
                Long executorId = this.getRemoteGroupByExecutorId(node, request);
                if (executorId == null) continue;
                if (executorId != -1L) {
                    logger.debug("{}: get an executorId {} for {}@{} from {}", new Object[]{this.metaGroupMember.getName(), executorId, aggregationTypes, path, node});
                    RemoteGroupByExecutor remoteGroupByExecutor = new RemoteGroupByExecutor(executorId, node, partitionGroup.getHeader());
                    for (Integer aggregationType : aggregationTypes) {
                        remoteGroupByExecutor.addAggregateResult(AggregateResultFactory.getAggrResultByType((AggregationType)AggregationType.values()[aggregationType], (TSDataType)dataType, (boolean)ascending));
                    }
                    RemoteGroupByExecutor remoteGroupByExecutor2 = remoteGroupByExecutor;
                    return remoteGroupByExecutor2;
                }
                logger.debug("{}: no data for {} from {}", new Object[]{this.metaGroupMember.getName(), path, node});
                EmptyReader emptyReader = new EmptyReader();
                return emptyReader;
            }
            catch (TApplicationException e) {
                logger.error(this.metaGroupMember.getName() + ": Cannot query " + path + " from " + node, (Throwable)e);
                throw new StorageEngineException(e.getMessage());
            }
            catch (IOException | TException e) {
                logger.error(this.metaGroupMember.getName() + ": Cannot query " + path + " from " + node, e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(this.metaGroupMember.getName() + ": Cannot query " + path + " from " + node, (Throwable)e);
            }
            finally {
                ((RemoteQueryContext)context).registerRemoteNode(node, partitionGroup.getHeader());
            }
        }
        throw new StorageEngineException((Throwable)new RequestTimeOutException("Query " + path + " in " + partitionGroup));
    }

    private Long getRemoteGroupByExecutorId(Node node, GroupByRequest request) throws IOException, TException, InterruptedException {
        Long executorId;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            executorId = SyncClientAdaptor.getGroupByExecutor(client, request);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                executorId = syncDataClient.getGroupByExecutor(request);
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return executorId;
    }

    public IBatchReader getSeriesBatchReader(PartialPath path, Set<String> allSensors, TSDataType dataType, Filter timeFilter, Filter valueFilter, QueryContext context, DataGroupMember dataGroupMember, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException, QueryProcessException, IOException {
        return this.getSeriesBatchReader(path, allSensors, dataType, timeFilter, valueFilter, context, dataGroupMember, ascending, requiredSlots, true);
    }

    public IBatchReader getSeriesBatchReader(PartialPath path, Set<String> allSensors, TSDataType dataType, Filter timeFilter, Filter valueFilter, QueryContext context, DataGroupMember dataGroupMember, boolean ascending, Set<Integer> requiredSlots, boolean syncLeader) throws StorageEngineException, QueryProcessException, IOException {
        if (syncLeader) {
            try {
                dataGroupMember.syncLeaderWithConsistencyCheck(false);
            }
            catch (CheckConsistencyException e) {
                throw new StorageEngineException((Throwable)e);
            }
        }
        Map<PartitionGroup, Set<Integer>> holderSlotMap = dataGroupMember.getPreviousHolderSlotMap();
        if (requiredSlots == null && !holderSlotMap.isEmpty()) {
            ManagedSeriesReader mergeReader = ascending ? new ManagedPriorityMergeReader(dataType) : new ManagedDescPriorityMergeReader(dataType);
            IPointReader seriesPointReader = this.getSeriesPointReader(path, allSensors, dataType, timeFilter, valueFilter, context, dataGroupMember, ascending, null);
            mergeReader.addReader(seriesPointReader, 1L);
            logger.debug("{}: Sending data query of {} to {} groups due to data is in the state of data migration", new Object[]{this.metaGroupMember.getName(), path, holderSlotMap.size()});
            for (Map.Entry<PartitionGroup, Set<Integer>> entry : holderSlotMap.entrySet()) {
                IPointReader seriesReader = this.getSeriesReader(entry.getKey(), path, allSensors, timeFilter, valueFilter, context, dataType, ascending, entry.getValue());
                mergeReader.addReader(seriesReader, 0L);
            }
            return (IBatchReader)mergeReader;
        }
        SeriesReader seriesReader = this.getSeriesReader(path, allSensors, dataType, timeFilter, valueFilter, context, dataGroupMember.getHeader(), ascending, requiredSlots);
        if (seriesReader.isEmpty()) {
            return null;
        }
        return new SeriesRawDataBatchReader(seriesReader);
    }

    public IBatchReader getMultSeriesBatchReader(List<MeasurementPath> paths, Map<String, Set<String>> allSensors, List<TSDataType> dataTypes, Filter timeFilter, Filter valueFilter, QueryContext context, DataGroupMember dataGroupMember, boolean ascending) throws StorageEngineException, QueryProcessException, IOException {
        try {
            dataGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        HashMap partialPathBatchReaderMap = Maps.newHashMap();
        for (int i = 0; i < paths.size(); ++i) {
            PartialPath partialPath = (PartialPath)paths.get(i);
            IBatchReader batchReader = this.getSeriesBatchReader(partialPath, allSensors.get(partialPath.getFullPath()), dataTypes.get(i), timeFilter, valueFilter, context, dataGroupMember, ascending, null, false);
            partialPathBatchReaderMap.put(partialPath.getFullPath(), batchReader);
        }
        return new MultBatchReader(partialPathBatchReaderMap);
    }

    public IReaderByTimestamp getReaderByTimestamp(PartialPath path, Set<String> allSensors, TSDataType dataType, QueryContext context, DataGroupMember dataGroupMember, boolean ascending, Set<Integer> requiredSlots) throws StorageEngineException, QueryProcessException {
        try {
            dataGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        Map<PartitionGroup, Set<Integer>> holderSlotMap = dataGroupMember.getPreviousHolderSlotMap();
        Filter timeFilter = TimeFilter.defaultTimeFilter((boolean)ascending);
        try {
            if (requiredSlots == null && !holderSlotMap.isEmpty()) {
                ManagedSeriesReader mergeReader = ascending ? new ManagedPriorityMergeReader(dataType) : new ManagedDescPriorityMergeReader(dataType);
                IPointReader seriesPointReader = this.getSeriesPointReader(path, allSensors, dataType, timeFilter, null, context, dataGroupMember, ascending, null);
                mergeReader.addReader(seriesPointReader, 1L);
                logger.debug("{}: Sending data query of {} to {} groups due to data is in the state of data migration", new Object[]{this.metaGroupMember.getName(), path, holderSlotMap.size()});
                for (Map.Entry<PartitionGroup, Set<Integer>> entry : holderSlotMap.entrySet()) {
                    IPointReader seriesReader = this.getSeriesReader(entry.getKey(), path, allSensors, timeFilter, null, context, dataType, ascending, entry.getValue());
                    mergeReader.addReader(seriesReader, 0L);
                }
                return new ByTimestampReaderAdapter((IPointReader)mergeReader);
            }
            SeriesReader seriesReader = this.getSeriesReader(path, allSensors, dataType, timeFilter, null, context, dataGroupMember.getHeader(), ascending, requiredSlots);
            if (seriesReader.isEmpty()) {
                return null;
            }
            return new SeriesReaderByTimestamp(seriesReader, ascending);
        }
        catch (IOException e) {
            throw new QueryProcessException((Throwable)e, TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }
}

