/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.apache.iotdb.tsfile.utils.Murmur128Hash;

public class BloomFilter {
    private static final int MINIMAL_SIZE = 256;
    private static final int MAXIMAL_HASH_FUNCTION_SIZE = 8;
    private static final int[] SEEDS = new int[]{5, 7, 11, 19, 31, 37, 43, 59};
    private int size;
    private int hashFunctionSize;
    private BitSet bits;
    private HashFunction[] func;

    private BloomFilter(byte[] bytes, int size, int hashFunctionSize) {
        this.size = size;
        this.hashFunctionSize = hashFunctionSize;
        this.func = new HashFunction[hashFunctionSize];
        for (int i = 0; i < hashFunctionSize; ++i) {
            this.func[i] = new HashFunction(size, SEEDS[i]);
        }
        this.bits = BitSet.valueOf(bytes);
    }

    private BloomFilter(int size, int hashFunctionSize) {
        this.size = size;
        this.hashFunctionSize = hashFunctionSize;
        this.func = new HashFunction[hashFunctionSize];
        for (int i = 0; i < hashFunctionSize; ++i) {
            this.func[i] = new HashFunction(size, SEEDS[i]);
        }
        this.bits = new BitSet(size);
    }

    public static BloomFilter getEmptyBloomFilter(double errorPercent, int numOfString) {
        errorPercent = Math.max(errorPercent, 0.01);
        errorPercent = Math.min(errorPercent, 0.1);
        double ln2 = Math.log(2.0);
        int size = (int)((double)(-numOfString) * Math.log(errorPercent) / ln2 / ln2) + 1;
        int hashFunctionSize = (int)(-Math.log(errorPercent) / ln2) + 1;
        return new BloomFilter(Math.max(256, size), Math.min(8, hashFunctionSize));
    }

    public static BloomFilter buildBloomFilter(byte[] bytes, int size, int hashFunctionSize) {
        return new BloomFilter(bytes, size, Math.min(8, hashFunctionSize));
    }

    public int getHashFunctionSize() {
        return this.hashFunctionSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void add(String value) {
        for (HashFunction f : this.func) {
            this.bits.set(f.hash(value), true);
        }
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        boolean ret = true;
        int index = 0;
        while (ret && index < this.hashFunctionSize) {
            ret = this.bits.get(this.func[index++].hash(value));
        }
        return ret;
    }

    public int getBitCount() {
        int res = 0;
        for (int i = 0; i < this.size; ++i) {
            res += this.bits.get(i) ? 1 : 0;
        }
        return res;
    }

    public byte[] serialize() {
        return this.bits.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomFilter that = (BloomFilter)o;
        return this.size == that.size && this.hashFunctionSize == that.hashFunctionSize && Objects.equals(this.bits, that.bits) && Arrays.equals(this.func, that.func);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.hashFunctionSize, this.bits, this.func);
    }

    private class HashFunction {
        private int cap;
        private int seed;

        HashFunction(int cap, int seed) {
            this.cap = cap;
            this.seed = seed;
        }

        public int hash(String value) {
            int res = Murmur128Hash.hash(value, this.seed);
            if (res == Integer.MIN_VALUE) {
                res = 0;
            }
            return Math.abs(res) % this.cap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashFunction that = (HashFunction)o;
            return this.cap == that.cap && this.seed == that.seed;
        }

        public int hashCode() {
            return Objects.hash(this.cap, this.seed);
        }
    }
}

