/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.monitor;

import java.util.Objects;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;

public class NodeStatus
implements Comparable<NodeStatus> {
    private static final long DEACTIVATION_VALID_INTERVAL_MS = 600000L;
    private TNodeStatus status;
    private long lastUpdateTime;
    private long lastResponseLatency;
    private volatile boolean isActivated = true;
    private long lastDeactivatedTime;

    @Override
    public int compareTo(NodeStatus o) {
        return Long.compare(this.lastResponseLatency, o.lastResponseLatency);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return this.lastUpdateTime == that.lastUpdateTime && this.lastResponseLatency == that.lastResponseLatency && Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.lastUpdateTime, this.lastResponseLatency);
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getLastResponseLatency() {
        return this.lastResponseLatency;
    }

    public TNodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(TNodeStatus status) {
        this.status = status;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setLastResponseLatency(long lastResponseLatency) {
        this.lastResponseLatency = lastResponseLatency;
    }

    public void activate() {
        this.isActivated = true;
    }

    public void deactivate() {
        this.isActivated = false;
        this.lastDeactivatedTime = System.currentTimeMillis();
    }

    public boolean isActivated() {
        return this.isActivated || System.currentTimeMillis() - this.lastDeactivatedTime > 600000L;
    }
}

