/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import java.io.File;
import java.io.UncheckedIOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(FileMetrics.class);
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private long walFileTotalSize = 0L;
    private long walFileTotalCount = 0L;
    private long sequenceFileTotalSize = 0L;
    private long sequenceFileTotalCount = 0L;
    private long unsequenceFileTotalSize = 0L;
    private long unsequenceFileTotalCount = 0L;

    public void bindTo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalSize, new String[]{Tag.NAME.toString(), "wal"});
        metricService.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalSize, new String[]{Tag.NAME.toString(), "seq"});
        metricService.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalSize, new String[]{Tag.NAME.toString(), "unseq"});
        metricService.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalCount, new String[]{Tag.NAME.toString(), "wal"});
        metricService.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalCount, new String[]{Tag.NAME.toString(), "seq"});
        metricService.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalCount, new String[]{Tag.NAME.toString(), "unseq"});
        if (metricService.isEnable() && null == this.currentServiceFuture) {
            this.currentServiceFuture = this.service.scheduleAtFixedRate(this::collect, 1L, MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), TimeUnit.SECONDS);
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(false);
            this.currentServiceFuture = null;
        }
        metricService.remove(MetricType.GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    private void collect() {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        String walDirs = IoTDBDescriptor.getInstance().getConfig().getWalDir();
        this.walFileTotalSize = org.apache.iotdb.db.utils.FileUtils.getDirSize(walDirs);
        this.sequenceFileTotalSize = Stream.of(dataDirs).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return org.apache.iotdb.db.utils.FileUtils.getDirSize(dir);
        }).sum();
        this.unsequenceFileTotalSize = Stream.of(dataDirs).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return org.apache.iotdb.db.utils.FileUtils.getDirSize(dir);
        }).sum();
        File walFolder = new File(walDirs);
        if (walFolder.exists() && walFolder.isDirectory()) {
            this.walFileTotalCount = FileUtils.listFiles((File)new File(walDirs), null, (boolean)true).size();
        }
        this.sequenceFileTotalCount = Stream.of(dataDirs).mapToLong(dir -> {
            File folder = new File(dir = dir + File.separator + "sequence");
            if (folder.exists()) {
                try {
                    return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
                }
                catch (UncheckedIOException exception) {
                    logger.debug("Failed when count sequence tsfile: ", (Throwable)exception);
                }
            }
            return 0L;
        }).sum();
        this.unsequenceFileTotalCount = Stream.of(dataDirs).mapToLong(dir -> {
            File folder = new File(dir = dir + File.separator + "unsequence");
            if (folder.exists()) {
                try {
                    return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
                }
                catch (UncheckedIOException exception) {
                    logger.debug("Failed when count unsequence tsfile: ", (Throwable)exception);
                }
            }
            return 0L;
        }).sum();
    }

    public long getWalFileTotalSize() {
        return this.walFileTotalSize;
    }

    public long getWalFileTotalCount() {
        return this.walFileTotalCount;
    }

    public long getSequenceFileTotalSize() {
        return this.sequenceFileTotalSize;
    }

    public long getSequenceFileTotalCount() {
        return this.sequenceFileTotalCount;
    }

    public long getUnsequenceFileTotalSize() {
        return this.unsequenceFileTotalSize;
    }

    public long getUnsequenceFileTotalCount() {
        return this.unsequenceFileTotalCount;
    }
}

