/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceEntry;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDTable {
    public static final Logger logger = LoggerFactory.getLogger(IDTable.class);
    public static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public void createAlignedTimeseries(CreateAlignedTimeSeriesPlan var1) throws MetadataException;

    public void createTimeseries(CreateTimeSeriesPlan var1) throws MetadataException;

    public IDeviceID getSeriesSchemas(InsertPlan var1) throws MetadataException;

    public void registerTrigger(PartialPath var1, IMeasurementMNode var2) throws MetadataException;

    public void deregisterTrigger(PartialPath var1, IMeasurementMNode var2) throws MetadataException;

    public TimeValuePair getLastCache(TimeseriesID var1) throws MetadataException;

    public void updateLastCache(TimeseriesID var1, TimeValuePair var2, boolean var3, Long var4) throws MetadataException;

    public void clear() throws IOException;

    public DeviceEntry getDeviceEntry(String var1);

    public List<DeviceEntry> getAllDeviceEntry();

    public void putSchemaEntry(String var1, String var2, SchemaEntry var3, boolean var4) throws MetadataException;

    public static PartialPath translateQueryPath(PartialPath fullPath) {
        if (!config.isEnableIDTable()) {
            return fullPath;
        }
        try {
            if (fullPath instanceof AlignedPath) {
                AlignedPath cur = (AlignedPath)fullPath;
                return new AlignedPath(DeviceIDFactory.getInstance().getDeviceID(cur).toStringID(), cur.getMeasurementList(), cur.getSchemaList());
            }
            TimeseriesID timeseriesID = new TimeseriesID(fullPath);
            return new MeasurementPath(timeseriesID.getDeviceID().toStringID(), timeseriesID.getMeasurement(), fullPath.getMeasurementSchema());
        }
        catch (MetadataException e) {
            logger.error("Error when translate query path: " + fullPath);
            throw new IllegalArgumentException("can't translate path to device id, path is: " + fullPath);
        }
    }

    public Map<IDeviceID, DeviceEntry>[] getIdTables();

    public IDiskSchemaManager getIDiskSchemaManager();
}

