/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;

public class QueryFirstRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=613");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=615");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=614");
    private final RequestHeader requestHeader;
    private final ViewDescription view;
    private final NodeTypeDescription[] nodeTypes;
    private final ContentFilter filter;
    private final UInteger maxDataSetsToReturn;
    private final UInteger maxReferencesToReturn;

    public QueryFirstRequest(RequestHeader requestHeader, ViewDescription view, NodeTypeDescription[] nodeTypes, ContentFilter filter, UInteger maxDataSetsToReturn, UInteger maxReferencesToReturn) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.nodeTypes = nodeTypes;
        this.filter = filter;
        this.maxDataSetsToReturn = maxDataSetsToReturn;
        this.maxReferencesToReturn = maxReferencesToReturn;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public NodeTypeDescription[] getNodeTypes() {
        return this.nodeTypes;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public UInteger getMaxDataSetsToReturn() {
        return this.maxDataSetsToReturn;
    }

    public UInteger getMaxReferencesToReturn() {
        return this.maxReferencesToReturn;
    }

    protected QueryFirstRequest(QueryFirstRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((QueryFirstRequestBuilder)b).requestHeader;
        this.view = ((QueryFirstRequestBuilder)b).view;
        this.nodeTypes = ((QueryFirstRequestBuilder)b).nodeTypes;
        this.filter = ((QueryFirstRequestBuilder)b).filter;
        this.maxDataSetsToReturn = ((QueryFirstRequestBuilder)b).maxDataSetsToReturn;
        this.maxReferencesToReturn = ((QueryFirstRequestBuilder)b).maxReferencesToReturn;
    }

    public static QueryFirstRequestBuilder<?, ?> builder() {
        return new QueryFirstRequestBuilderImpl();
    }

    public QueryFirstRequestBuilder<?, ?> toBuilder() {
        return new QueryFirstRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryFirstRequest)) {
            return false;
        }
        QueryFirstRequest other = (QueryFirstRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        ViewDescription this$view = this.getView();
        ViewDescription other$view = other.getView();
        if (this$view == null ? other$view != null : !((Object)this$view).equals(other$view)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNodeTypes(), other.getNodeTypes())) {
            return false;
        }
        ContentFilter this$filter = this.getFilter();
        ContentFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        UInteger this$maxDataSetsToReturn = this.getMaxDataSetsToReturn();
        UInteger other$maxDataSetsToReturn = other.getMaxDataSetsToReturn();
        if (this$maxDataSetsToReturn == null ? other$maxDataSetsToReturn != null : !((Object)this$maxDataSetsToReturn).equals(other$maxDataSetsToReturn)) {
            return false;
        }
        UInteger this$maxReferencesToReturn = this.getMaxReferencesToReturn();
        UInteger other$maxReferencesToReturn = other.getMaxReferencesToReturn();
        return !(this$maxReferencesToReturn == null ? other$maxReferencesToReturn != null : !((Object)this$maxReferencesToReturn).equals(other$maxReferencesToReturn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryFirstRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        ViewDescription $view = this.getView();
        result = result * 59 + ($view == null ? 43 : ((Object)$view).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodeTypes());
        ContentFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        UInteger $maxDataSetsToReturn = this.getMaxDataSetsToReturn();
        result = result * 59 + ($maxDataSetsToReturn == null ? 43 : ((Object)$maxDataSetsToReturn).hashCode());
        UInteger $maxReferencesToReturn = this.getMaxReferencesToReturn();
        result = result * 59 + ($maxReferencesToReturn == null ? 43 : ((Object)$maxReferencesToReturn).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryFirstRequest(requestHeader=" + this.getRequestHeader() + ", view=" + this.getView() + ", nodeTypes=" + Arrays.deepToString(this.getNodeTypes()) + ", filter=" + this.getFilter() + ", maxDataSetsToReturn=" + this.getMaxDataSetsToReturn() + ", maxReferencesToReturn=" + this.getMaxReferencesToReturn() + ")";
    }

    private static final class QueryFirstRequestBuilderImpl
    extends QueryFirstRequestBuilder<QueryFirstRequest, QueryFirstRequestBuilderImpl> {
        private QueryFirstRequestBuilderImpl() {
        }

        @Override
        protected QueryFirstRequestBuilderImpl self() {
            return this;
        }

        @Override
        public QueryFirstRequest build() {
            return new QueryFirstRequest(this);
        }
    }

    public static abstract class QueryFirstRequestBuilder<C extends QueryFirstRequest, B extends QueryFirstRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private ViewDescription view;
        private NodeTypeDescription[] nodeTypes;
        private ContentFilter filter;
        private UInteger maxDataSetsToReturn;
        private UInteger maxReferencesToReturn;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QueryFirstRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(QueryFirstRequest instance, QueryFirstRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.view(instance.view);
            b.nodeTypes(instance.nodeTypes);
            b.filter(instance.filter);
            b.maxDataSetsToReturn(instance.maxDataSetsToReturn);
            b.maxReferencesToReturn(instance.maxReferencesToReturn);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B view(ViewDescription view) {
            this.view = view;
            return (B)this.self();
        }

        public B nodeTypes(NodeTypeDescription[] nodeTypes) {
            this.nodeTypes = nodeTypes;
            return (B)this.self();
        }

        public B filter(ContentFilter filter) {
            this.filter = filter;
            return (B)this.self();
        }

        public B maxDataSetsToReturn(UInteger maxDataSetsToReturn) {
            this.maxDataSetsToReturn = maxDataSetsToReturn;
            return (B)this.self();
        }

        public B maxReferencesToReturn(UInteger maxReferencesToReturn) {
            this.maxReferencesToReturn = maxReferencesToReturn;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "QueryFirstRequest.QueryFirstRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", view=" + this.view + ", nodeTypes=" + Arrays.deepToString(this.nodeTypes) + ", filter=" + this.filter + ", maxDataSetsToReturn=" + this.maxDataSetsToReturn + ", maxReferencesToReturn=" + this.maxReferencesToReturn + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryFirstRequest> {
        @Override
        public Class<QueryFirstRequest> getType() {
            return QueryFirstRequest.class;
        }

        @Override
        public QueryFirstRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ViewDescription view = (ViewDescription)decoder.readStruct("View", ViewDescription.TYPE_ID);
            NodeTypeDescription[] nodeTypes = (NodeTypeDescription[])decoder.readStructArray("NodeTypes", NodeTypeDescription.TYPE_ID);
            ContentFilter filter = (ContentFilter)decoder.readStruct("Filter", ContentFilter.TYPE_ID);
            UInteger maxDataSetsToReturn = decoder.readUInt32("MaxDataSetsToReturn");
            UInteger maxReferencesToReturn = decoder.readUInt32("MaxReferencesToReturn");
            return new QueryFirstRequest(requestHeader, view, nodeTypes, filter, maxDataSetsToReturn, maxReferencesToReturn);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryFirstRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("View", (Object)value.getView(), ViewDescription.TYPE_ID);
            encoder.writeStructArray("NodeTypes", (Object[])value.getNodeTypes(), NodeTypeDescription.TYPE_ID);
            encoder.writeStruct("Filter", (Object)value.getFilter(), ContentFilter.TYPE_ID);
            encoder.writeUInt32("MaxDataSetsToReturn", value.getMaxDataSetsToReturn());
            encoder.writeUInt32("MaxReferencesToReturn", value.getMaxReferencesToReturn());
        }
    }
}

