/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.basic.OperatorType;
import org.apache.tsfile.read.filter.basic.TimeFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public final class ExtractTimeFilterOperators {
    private static final String OPERATOR_TO_STRING_FORMAT = "extract %s from time %s %s";

    private ExtractTimeFilterOperators() {
    }

    public static final class ExtractTimeGtEq
    extends ExtractTimeCompareFilter {
        public ExtractTimeGtEq(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(constant, field, zoneId, currPrecision);
        }

        public ExtractTimeGtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return (Long)this.evaluateFunction.apply(time) >= this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) == false || (Long)this.evaluateFunction.apply(endTime) >= this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) != false && (Long)this.evaluateFunction.apply(startTime) >= this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.field == Field.YEAR) {
                int year = (int)this.constant;
                return Collections.singletonList(new TimeRange((Long)this.GET_YEAR_TIMESTAMP.apply(year), Long.MAX_VALUE));
            }
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new ExtractTimeLt(this.constant, this.field, this.zoneId, this.currPrecision);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_TIME_GTEQ;
        }
    }

    public static final class ExtractTimeGt
    extends ExtractTimeCompareFilter {
        public ExtractTimeGt(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(constant, field, zoneId, currPrecision);
        }

        public ExtractTimeGt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return (Long)this.evaluateFunction.apply(time) > this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) == false || (Long)this.evaluateFunction.apply(endTime) > this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) != false && (Long)this.evaluateFunction.apply(startTime) > this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.field == Field.YEAR) {
                int year = (int)this.constant;
                return Collections.singletonList(new TimeRange((Long)this.GET_YEAR_TIMESTAMP.apply(year + 1), Long.MAX_VALUE));
            }
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new ExtractTimeLtEq(this.constant, this.field, this.zoneId, this.currPrecision);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_TIME_GT;
        }
    }

    public static final class ExtractTimeLtEq
    extends ExtractTimeCompareFilter {
        public ExtractTimeLtEq(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(constant, field, zoneId, currPrecision);
        }

        public ExtractTimeLtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return (Long)this.evaluateFunction.apply(time) <= this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) == false || (Long)this.evaluateFunction.apply(startTime) <= this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) != false && (Long)this.evaluateFunction.apply(endTime) <= this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.field == Field.YEAR) {
                int year = (int)this.constant;
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, (Long)this.GET_YEAR_TIMESTAMP.apply(year + 1) - 1L));
            }
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new ExtractTimeGt(this.constant, this.field, this.zoneId, this.currPrecision);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_TIME_LTEQ;
        }
    }

    public static final class ExtractTimeLt
    extends ExtractTimeCompareFilter {
        public ExtractTimeLt(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(constant, field, zoneId, currPrecision);
        }

        public ExtractTimeLt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return (Long)this.evaluateFunction.apply(time) < this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) == false || (Long)this.evaluateFunction.apply(startTime) < this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) != false && (Long)this.evaluateFunction.apply(endTime) < this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.field == Field.YEAR) {
                int year = (int)this.constant;
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, (Long)this.GET_YEAR_TIMESTAMP.apply(year) - 1L));
            }
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new ExtractTimeGtEq(this.constant, this.field, this.zoneId, this.currPrecision);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_TIME_LT;
        }
    }

    public static final class ExtractTimeNotEq
    extends ExtractTimeCompareFilter {
        public ExtractTimeNotEq(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(constant, field, zoneId, currPrecision);
        }

        public ExtractTimeNotEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return (Long)this.evaluateFunction.apply(time) != this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) == false || (Long)this.evaluateFunction.apply(startTime) != this.constant || (Long)this.evaluateFunction.apply(endTime) != this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) != false && ((Long)this.evaluateFunction.apply(startTime) > this.constant || (Long)this.evaluateFunction.apply(endTime) < this.constant);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.field == Field.YEAR) {
                ArrayList<TimeRange> res = new ArrayList<TimeRange>();
                int year = (int)this.constant;
                res.add(new TimeRange(Long.MIN_VALUE, (Long)this.GET_YEAR_TIMESTAMP.apply(year) - 1L));
                res.add(new TimeRange((Long)this.GET_YEAR_TIMESTAMP.apply(year + 1), Long.MAX_VALUE));
                return res;
            }
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new ExtractTimeEq(this.constant, this.field, this.zoneId, this.currPrecision);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_TIME_NEQ;
        }
    }

    public static final class ExtractTimeEq
    extends ExtractTimeCompareFilter {
        public ExtractTimeEq(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(constant, field, zoneId, currPrecision);
        }

        public ExtractTimeEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return (Long)this.evaluateFunction.apply(time) == this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) == false || (Long)this.evaluateFunction.apply(endTime) >= this.constant && (Long)this.evaluateFunction.apply(startTime) <= this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return (Boolean)this.truncatedEqualsFunction.apply(startTime, endTime) != false && (Long)this.evaluateFunction.apply(startTime) == this.constant && (Long)this.evaluateFunction.apply(endTime) == this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            if (this.field == Field.YEAR) {
                int year = (int)this.constant;
                return Collections.singletonList(new TimeRange((Long)this.GET_YEAR_TIMESTAMP.apply(year), (Long)this.GET_YEAR_TIMESTAMP.apply(year + 1) - 1L));
            }
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new ExtractTimeNotEq(this.constant, this.field, this.zoneId, this.currPrecision);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_TIME_EQ;
        }
    }

    static abstract class ExtractTimeCompareFilter
    extends TimeFilter {
        protected final long constant;
        protected final Field field;
        protected final ZoneId zoneId;
        protected final TimeUnit currPrecision;
        private final transient Function<Long, Long> CAST_TIMESTAMP_TO_MS;
        private final transient Function<Long, Long> EXTRACT_TIMESTAMP_MS_PART;
        private final transient Function<Long, Long> EXTRACT_TIMESTAMP_US_PART;
        private final transient Function<Long, Long> EXTRACT_TIMESTAMP_NS_PART;
        protected final transient Function<Integer, Long> GET_YEAR_TIMESTAMP;
        protected final transient Function<Long, Long> evaluateFunction;
        protected final transient BiFunction<Long, Long, Boolean> truncatedEqualsFunction;

        protected ExtractTimeCompareFilter(long constant, Field field, ZoneId zoneId, TimeUnit currPrecision) {
            this.constant = constant;
            this.field = field;
            this.zoneId = zoneId;
            this.currPrecision = currPrecision;
            switch (currPrecision) {
                case MICROSECONDS: {
                    this.CAST_TIMESTAMP_TO_MS = timestamp -> timestamp / 1000L;
                    this.EXTRACT_TIMESTAMP_MS_PART = timestamp -> Math.floorMod((long)timestamp, 1000000L) / 1000L;
                    this.EXTRACT_TIMESTAMP_US_PART = timestamp -> Math.floorMod((long)timestamp, 1000L);
                    this.EXTRACT_TIMESTAMP_NS_PART = timestamp -> 0L;
                    this.GET_YEAR_TIMESTAMP = year -> Math.multiplyExact(LocalDate.of((int)year, 1, 1).atStartOfDay(zoneId).toEpochSecond(), 1000000L);
                    break;
                }
                case NANOSECONDS: {
                    this.CAST_TIMESTAMP_TO_MS = timestamp -> timestamp / 1000000L;
                    this.EXTRACT_TIMESTAMP_MS_PART = timestamp -> Math.floorMod((long)timestamp, 1000000000L) / 1000000L;
                    this.EXTRACT_TIMESTAMP_US_PART = timestamp -> Math.floorMod((long)timestamp, 1000000L) / 1000L;
                    this.EXTRACT_TIMESTAMP_NS_PART = timestamp -> Math.floorMod((long)timestamp, 1000L);
                    this.GET_YEAR_TIMESTAMP = year -> Math.multiplyExact(LocalDate.of((int)year, 1, 1).atStartOfDay(zoneId).toEpochSecond(), 1000000000L);
                    break;
                }
                default: {
                    this.CAST_TIMESTAMP_TO_MS = timestamp -> timestamp;
                    this.EXTRACT_TIMESTAMP_MS_PART = timestamp -> Math.floorMod((long)timestamp, 1000L);
                    this.EXTRACT_TIMESTAMP_US_PART = timestamp -> 0L;
                    this.EXTRACT_TIMESTAMP_NS_PART = timestamp -> 0L;
                    this.GET_YEAR_TIMESTAMP = year -> Math.multiplyExact(LocalDate.of((int)year, 1, 1).atStartOfDay(zoneId).toEpochSecond(), 1000L);
                }
            }
            this.evaluateFunction = this.constructEvaluateFunction(field, zoneId);
            this.truncatedEqualsFunction = this.constructTruncatedEqualsFunction(field, zoneId);
        }

        protected Function<Long, Long> constructEvaluateFunction(Field field, ZoneId zoneId) {
            switch (field) {
                case YEAR: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getYear();
                }
                case QUARTER: {
                    return timestamp -> ((long)this.convertToZonedDateTime((long)timestamp, zoneId).getMonthValue() + 2L) / 3L;
                }
                case MONTH: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getMonthValue();
                }
                case WEEK: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getLong(ChronoField.ALIGNED_WEEK_OF_YEAR);
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getDayOfMonth();
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getDayOfWeek().getValue();
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getDayOfYear();
                }
                case HOUR: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getHour();
                }
                case MINUTE: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getMinute();
                }
                case SECOND: {
                    return timestamp -> this.convertToZonedDateTime((long)timestamp, zoneId).getSecond();
                }
                case MS: {
                    return this.EXTRACT_TIMESTAMP_MS_PART;
                }
                case US: {
                    return this.EXTRACT_TIMESTAMP_US_PART;
                }
                case NS: {
                    return this.EXTRACT_TIMESTAMP_NS_PART;
                }
            }
            throw new UnsupportedOperationException("Unexpected extract field: " + (Object)((Object)field));
        }

        protected BiFunction<Long, Long, Boolean> constructTruncatedEqualsFunction(Field field, ZoneId zoneId) {
            switch (field) {
                case YEAR: {
                    return (timestamp1, timestamp2) -> true;
                }
                case QUARTER: 
                case MONTH: 
                case WEEK: 
                case DAY_OF_YEAR: 
                case DOY: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).withMonth(1).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).withMonth(1).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).with(DayOfWeek.MONDAY).truncatedTo(ChronoUnit.DAYS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).with(DayOfWeek.MONDAY).truncatedTo(ChronoUnit.DAYS));
                }
                case HOUR: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).truncatedTo(ChronoUnit.DAYS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).truncatedTo(ChronoUnit.DAYS));
                }
                case MINUTE: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).truncatedTo(ChronoUnit.HOURS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).truncatedTo(ChronoUnit.HOURS));
                }
                case SECOND: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).truncatedTo(ChronoUnit.MINUTES).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).truncatedTo(ChronoUnit.MINUTES));
                }
                case MS: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).truncatedTo(ChronoUnit.SECONDS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).truncatedTo(ChronoUnit.SECONDS));
                }
                case US: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).truncatedTo(ChronoUnit.MILLIS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).truncatedTo(ChronoUnit.MILLIS));
                }
                case NS: {
                    return (timestamp1, timestamp2) -> this.convertToZonedDateTime((long)timestamp1, zoneId).truncatedTo(ChronoUnit.MICROS).equals(this.convertToZonedDateTime((long)timestamp2, zoneId).truncatedTo(ChronoUnit.MICROS));
                }
            }
            throw new UnsupportedOperationException("Unexpected extract field: " + (Object)((Object)field));
        }

        private ZonedDateTime convertToZonedDateTime(long timestamp, ZoneId zoneId) {
            timestamp = this.CAST_TIMESTAMP_TO_MS.apply(timestamp);
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        }

        protected ExtractTimeCompareFilter(ByteBuffer buffer) {
            this(ReadWriteIOUtils.readLong(buffer), Field.values()[ReadWriteIOUtils.readInt(buffer)], ZoneId.of(Objects.requireNonNull(ReadWriteIOUtils.readString(buffer))), TimeUnit.values()[ReadWriteIOUtils.readInt(buffer)]);
        }

        public long getConstant() {
            return this.constant;
        }

        public Field getField() {
            return this.field;
        }

        public TimeUnit getCurrPrecision() {
            return this.currPrecision;
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.constant, (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.field.ordinal(), (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.zoneId.getId(), (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.currPrecision.ordinal(), (OutputStream)outputStream);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtractTimeCompareFilter that = (ExtractTimeCompareFilter)o;
            return this.constant == that.constant && this.zoneId.equals(that.zoneId) && this.currPrecision == that.currPrecision;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.constant, this.field, this.zoneId, this.currPrecision});
        }

        public String toString() {
            return String.format(ExtractTimeFilterOperators.OPERATOR_TO_STRING_FORMAT, new Object[]{this.field, this.getOperatorType().getSymbol(), this.constant});
        }
    }

    public static enum Field {
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        DOW,
        DAY_OF_YEAR,
        DOY,
        HOUR,
        MINUTE,
        SECOND,
        MS,
        US,
        NS;

    }
}

