/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BooleanConversions {
    private BooleanConversions() {
    }

    @NotNull
    static UByte booleanToByte(@NotNull Boolean b) {
        return Unsigned.ubyte((int)(b != false ? 1 : 0));
    }

    @NotNull
    static Double booleanToDouble(@NotNull Boolean b) {
        return b != false ? 1.0 : 0.0;
    }

    @NotNull
    static Float booleanToFloat(@NotNull Boolean b) {
        return Float.valueOf(b != false ? 1.0f : 0.0f);
    }

    @NotNull
    static Short booleanToInt16(@NotNull Boolean b) {
        return b != false ? (short)1 : 0;
    }

    @NotNull
    static Integer booleanToInt32(@NotNull Boolean b) {
        return b != false ? 1 : 0;
    }

    @NotNull
    static Long booleanToInt64(@NotNull Boolean b) {
        return b != false ? 1L : 0L;
    }

    @NotNull
    static Byte booleanToSByte(@NotNull Boolean b) {
        return b != false ? (byte)1 : 0;
    }

    @NotNull
    static String booleanToString(@NotNull Boolean b) {
        return b != false ? "1" : "0";
    }

    @NotNull
    static UShort booleanToUInt16(@NotNull Boolean b) {
        return b != false ? Unsigned.ushort((int)1) : Unsigned.ushort((int)0);
    }

    @NotNull
    static UInteger booleanToUInt32(@NotNull Boolean b) {
        return b != false ? Unsigned.uint((int)1) : Unsigned.uint((int)0);
    }

    @NotNull
    static ULong booleanToUInt64(@NotNull Boolean b) {
        return b != false ? Unsigned.ulong((long)1L) : Unsigned.ulong((long)0L);
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return implicit ? BooleanConversions.implicitConversion(b, targetType) : BooleanConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull Boolean b, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return BooleanConversions.booleanToString(b);
            }
        }
        return BooleanConversions.implicitConversion(b, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull Boolean b, BuiltinDataType targetType) {
        switch (targetType) {
            case Byte: {
                return BooleanConversions.booleanToByte(b);
            }
            case Double: {
                return BooleanConversions.booleanToDouble(b);
            }
            case Float: {
                return BooleanConversions.booleanToFloat(b);
            }
            case Int16: {
                return BooleanConversions.booleanToInt16(b);
            }
            case Int32: {
                return BooleanConversions.booleanToInt32(b);
            }
            case Int64: {
                return BooleanConversions.booleanToInt64(b);
            }
            case SByte: {
                return BooleanConversions.booleanToSByte(b);
            }
            case UInt16: {
                return BooleanConversions.booleanToUInt16(b);
            }
            case UInt32: {
                return BooleanConversions.booleanToUInt32(b);
            }
            case UInt64: {
                return BooleanConversions.booleanToUInt64(b);
            }
        }
        return null;
    }
}

