/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AddNodesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=486");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=488");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=487");
    private final RequestHeader requestHeader;
    private final AddNodesItem[] nodesToAdd;

    public AddNodesRequest(RequestHeader requestHeader, AddNodesItem[] nodesToAdd) {
        this.requestHeader = requestHeader;
        this.nodesToAdd = nodesToAdd;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public AddNodesItem[] getNodesToAdd() {
        return this.nodesToAdd;
    }

    protected AddNodesRequest(AddNodesRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((AddNodesRequestBuilder)b).requestHeader;
        this.nodesToAdd = ((AddNodesRequestBuilder)b).nodesToAdd;
    }

    public static AddNodesRequestBuilder<?, ?> builder() {
        return new AddNodesRequestBuilderImpl();
    }

    public AddNodesRequestBuilder<?, ?> toBuilder() {
        return new AddNodesRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddNodesRequest)) {
            return false;
        }
        AddNodesRequest other = (AddNodesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToAdd(), other.getNodesToAdd());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddNodesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToAdd());
        return result;
    }

    @Override
    public String toString() {
        return "AddNodesRequest(requestHeader=" + this.getRequestHeader() + ", nodesToAdd=" + Arrays.deepToString(this.getNodesToAdd()) + ")";
    }

    private static final class AddNodesRequestBuilderImpl
    extends AddNodesRequestBuilder<AddNodesRequest, AddNodesRequestBuilderImpl> {
        private AddNodesRequestBuilderImpl() {
        }

        @Override
        protected AddNodesRequestBuilderImpl self() {
            return this;
        }

        @Override
        public AddNodesRequest build() {
            return new AddNodesRequest(this);
        }
    }

    public static abstract class AddNodesRequestBuilder<C extends AddNodesRequest, B extends AddNodesRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private AddNodesItem[] nodesToAdd;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AddNodesRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AddNodesRequest instance, AddNodesRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.nodesToAdd(instance.nodesToAdd);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B nodesToAdd(AddNodesItem[] nodesToAdd) {
            this.nodesToAdd = nodesToAdd;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AddNodesRequest.AddNodesRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", nodesToAdd=" + Arrays.deepToString(this.nodesToAdd) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AddNodesRequest> {
        @Override
        public Class<AddNodesRequest> getType() {
            return AddNodesRequest.class;
        }

        @Override
        public AddNodesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            AddNodesItem[] nodesToAdd = (AddNodesItem[])decoder.readStructArray("NodesToAdd", AddNodesItem.TYPE_ID);
            return new AddNodesRequest(requestHeader, nodesToAdd);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AddNodesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("NodesToAdd", (Object[])value.getNodesToAdd(), AddNodesItem.TYPE_ID);
        }
    }
}

