/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.options;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInclusionOptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInclusionOptions.class);
    public static final List<PartialPath> treeOnlySyncPrefixes = Collections.singletonList(new PartialPath(new String[]{"schema", "timeseries"}));
    public static final List<PartialPath> tableOnlySyncPrefixes = Collections.unmodifiableList(Arrays.asList(new PartialPath(new String[]{"schema", "table"}), new PartialPath(new String[]{"auth", "role", "grant", "table"}), new PartialPath(new String[]{"auth", "role", "revoke", "table"}), new PartialPath(new String[]{"auth", "user", "grant", "table"}), new PartialPath(new String[]{"auth", "user", "revoke", "table"})));
    public static final String ALL = "all";
    private static final Set<PartialPath> TREE_OPTIONS = new HashSet<PartialPath>();
    private static final Set<PartialPath> TABLE_OPTIONS = new HashSet<PartialPath>();
    private static final Map<String, Set<String>> ALIAS_OPTIONS_MAP = new HashMap<String, Set<String>>();

    public static boolean hasAtLeastOneOption(String inclusionString, String exclusionString, boolean isTreeModelListened, boolean isTableModelListened) {
        try {
            Set<PartialPath> inclusion = PipeInclusionOptions.parseOptions(inclusionString);
            Set<PartialPath> exclusion = PipeInclusionOptions.parseOptions(exclusionString);
            Set<PartialPath> allOptions = PipeInclusionOptions.getOptions(isTreeModelListened, isTableModelListened);
            HashSet options = new HashSet();
            inclusion.forEach(option -> options.addAll(allOptions.stream().filter(path -> path.overlapWithFullPathPrefix((PartialPath)option)).collect(Collectors.toSet())));
            exclusion.forEach(option -> options.removeAll(allOptions.stream().filter(path -> path.overlapWithFullPathPrefix((PartialPath)option)).collect(Collectors.toSet())));
            return !options.isEmpty();
        }
        catch (IllegalPathException e) {
            LOGGER.warn("Illegal options (inclusion: {}, exclusion: {}) parsed when checking if at least one option is present: {}", new Object[]{inclusionString, exclusionString, e.getMessage(), e});
            return false;
        }
    }

    public static boolean optionsAreAllLegal(String options, boolean isTreeModelListened, boolean isTableModelListened) {
        try {
            return PipeInclusionOptions.parseOptions(options).stream().allMatch(prefix -> PipeInclusionOptions.getOptions(isTreeModelListened, isTableModelListened).stream().anyMatch(path -> path.overlapWithFullPathPrefix((PartialPath)prefix)));
        }
        catch (IllegalPathException e) {
            LOGGER.warn("Illegal options {} parsed when checking if all options are legal: {}", new Object[]{options, e.getMessage(), e});
            return false;
        }
    }

    private static Set<PartialPath> getOptions(boolean isTreeModelListened, boolean isTableModelListened) {
        if (isTreeModelListened) {
            if (isTableModelListened) {
                HashSet<PartialPath> allOptions = new HashSet<PartialPath>(TREE_OPTIONS);
                allOptions.addAll(TABLE_OPTIONS);
                return allOptions;
            }
            return TREE_OPTIONS;
        }
        return TABLE_OPTIONS;
    }

    public static String getInclusionString(PipeParameters parameters) {
        return parameters.getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data.insert");
    }

    public static String getExclusionString(PipeParameters parameters) {
        return parameters.getStringOrDefault(Arrays.asList("extractor.inclusion.exclusion", "source.inclusion.exclusion"), "");
    }

    public static Set<PartialPath> parseOptions(String optionsString) throws IllegalPathException {
        if (optionsString.isEmpty()) {
            return Collections.emptySet();
        }
        AtomicReference exception = new AtomicReference();
        Set<PartialPath> options = Arrays.stream(optionsString.toLowerCase().replace(" ", "").split(",")).flatMap(prefix -> ALIAS_OPTIONS_MAP.getOrDefault(prefix, Collections.singleton(prefix)).stream()).map(inclusion -> {
            try {
                return new PartialPath((String)inclusion);
            }
            catch (IllegalPathException e) {
                exception.set(e);
                return new PartialPath();
            }
        }).collect(Collectors.toSet());
        if (exception.get() != null) {
            throw (IllegalPathException)exception.get();
        }
        return options;
    }

    private PipeInclusionOptions() {
    }

    static {
        try {
            HashSet<PartialPath> commonOptions = new HashSet<PartialPath>();
            commonOptions.add(new PartialPath("data.insert"));
            commonOptions.add(new PartialPath("data.delete"));
            commonOptions.add(new PartialPath("schema.database.create"));
            commonOptions.add(new PartialPath("schema.database.alter"));
            commonOptions.add(new PartialPath("schema.database.drop"));
            commonOptions.add(new PartialPath("schema.ttl"));
            commonOptions.add(new PartialPath("auth.role.create"));
            commonOptions.add(new PartialPath("auth.role.drop"));
            commonOptions.add(new PartialPath("auth.role.grant"));
            commonOptions.add(new PartialPath("auth.role.revoke"));
            commonOptions.add(new PartialPath("auth.user.create"));
            commonOptions.add(new PartialPath("auth.user.alter"));
            commonOptions.add(new PartialPath("auth.user.drop"));
            commonOptions.add(new PartialPath("auth.user.grant"));
            commonOptions.add(new PartialPath("auth.user.revoke"));
            TREE_OPTIONS.addAll(commonOptions);
            TABLE_OPTIONS.addAll(commonOptions);
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.view.create"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.view.alter"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.view.drop"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.ordinary.create"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.ordinary.alter"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.ordinary.drop"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.create"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.set"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.unset"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.alter"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.drop"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.activate"));
            TREE_OPTIONS.add(new PartialPath("schema.timeseries.template.deactivate"));
            TABLE_OPTIONS.add(new PartialPath("schema.table.create"));
            TABLE_OPTIONS.add(new PartialPath("schema.table.alter"));
            TABLE_OPTIONS.add(new PartialPath("schema.table.drop"));
        }
        catch (IllegalPathException e) {
            LOGGER.error("Illegal path encountered when initializing LEGAL_OPTIONS.", (Throwable)e);
        }
        ALIAS_OPTIONS_MAP.put(ALL, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("data", "schema", "auth"))));
        ALIAS_OPTIONS_MAP.put("delete", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("data.delete", "schema.database.drop", "schema.timeseries.ordinary.delete", "schema.timeseries.view.drop", "schema.timeseries.template.drop", "schema.timeseries.template.unset", "schema.timeseries.template.deactivate", "auth.role.drop", "auth.role.revoke", "auth.user.drop", "auth.user.revoke"))));
        ALIAS_OPTIONS_MAP.put("schema.delete", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("schema.database.drop", "schema.timeseries.ordinary.delete", "schema.timeseries.view.drop", "schema.timeseries.template.drop", "schema.timeseries.template.unset", "schema.timeseries.template.deactivate"))));
        ALIAS_OPTIONS_MAP.put("auth.delete", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("auth.role.drop", "auth.role.revoke", "auth.user.drop", "auth.user.revoke"))));
    }
}

