/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.MultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class CoalesceColumnTransformer
extends MultiColumnTransformer {
    public CoalesceColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transform(childrenColumns, builder, i);
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transform(childrenColumns, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(List<Column> childrenColumns, ColumnBuilder builder, int i) {
        boolean allNull = true;
        for (Column column : childrenColumns) {
            if (column.isNull(i)) continue;
            allNull = false;
            builder.write(column, i);
            break;
        }
        if (allNull) {
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }
}

