/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.objects;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.diagnostics.objects.SessionsDiagnosticsSummaryObject;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.ServerDiagnosticsSummaryVariable;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SubscriptionDiagnosticsVariableArray;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDiagnosticsObject
extends AbstractLifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerDiagnosticsSummaryVariable serverDiagnosticsSummary;
    private SubscriptionDiagnosticsVariableArray subscriptionDiagnosticsVariableArray;
    private SessionsDiagnosticsSummaryObject sessionsDiagnosticsSummaryObject;
    private final OpcUaServer server;
    private final ServerDiagnosticsTypeNode node;
    private final NodeManager<UaNode> diagnosticsNodeManager;

    public ServerDiagnosticsObject(ServerDiagnosticsTypeNode node, NodeManager<UaNode> diagnosticsNodeManager) {
        this.node = node;
        this.diagnosticsNodeManager = diagnosticsNodeManager;
        this.server = node.getNodeContext().getServer();
    }

    @Override
    protected synchronized void onStartup() {
        this.logger.debug("ServerDiagnosticsNode onStartup()");
        this.configureServerDiagnosticsSummary();
        this.configureSubscriptionDiagnosticsArray();
        this.configureSessionDiagnosticsSummary();
        this.node.getSamplingIntervalDiagnosticsArrayNode().delete();
    }

    @Override
    protected synchronized void onShutdown() {
        this.logger.debug("ServerDiagnosticsNode onShutdown()");
        this.serverDiagnosticsSummary.shutdown();
        this.subscriptionDiagnosticsVariableArray.shutdown();
        this.sessionsDiagnosticsSummaryObject.shutdown();
        this.node.delete();
    }

    private void configureServerDiagnosticsSummary() {
        this.serverDiagnosticsSummary = new ServerDiagnosticsSummaryVariable(this.node.getServerDiagnosticsSummaryNode());
        this.serverDiagnosticsSummary.startup();
    }

    private void configureSubscriptionDiagnosticsArray() {
        this.subscriptionDiagnosticsVariableArray = new SubscriptionDiagnosticsVariableArray(this.node.getSubscriptionDiagnosticsArrayNode(), this.diagnosticsNodeManager){

            @Override
            protected List<Subscription> getSubscriptions() {
                return new ArrayList<Subscription>(ServerDiagnosticsObject.this.server.getSubscriptions().values());
            }
        };
        this.subscriptionDiagnosticsVariableArray.startup();
    }

    private void configureSessionDiagnosticsSummary() {
        this.sessionsDiagnosticsSummaryObject = new SessionsDiagnosticsSummaryObject(this.node.getSessionsDiagnosticsSummaryNode(), this.diagnosticsNodeManager);
        this.sessionsDiagnosticsSummaryObject.startup();
    }
}

