/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableId {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableId.class);
    private final String database;
    private final String tableName;

    public TableId(@Nullable String database, @Nonnull String tableName) {
        this.database = database;
        this.tableName = tableName;
    }

    String getDatabase() {
        return this.database;
    }

    String getTableName() {
        return this.tableName;
    }

    boolean belongTo(String database) {
        return Objects.equals(this.database, database);
    }

    int estimateSize() {
        return (int)(INSTANCE_SIZE + RamUsageEstimator.sizeOf((String)this.database));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableId)) {
            return false;
        }
        TableId tableId = (TableId)o;
        return Objects.equals(this.database, tableId.database) && Objects.equals(this.tableName, tableId.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.tableName);
    }
}

