/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MovingAverages;
import com.google.common.base.MoreObjects;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.metrics.core.utils.IoTDBMovingAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPrefetchingQueueStates {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingQueueStates.class);
    private static final double EPSILON = 1.0E-6;
    private static final double PREFETCH_MEMORY_THRESHOLD = SubscriptionConfig.getInstance().getSubscriptionPrefetchMemoryThreshold();
    private static final double PREFETCH_MISSING_RATE_THRESHOLD = SubscriptionConfig.getInstance().getSubscriptionPrefetchMissingRateThreshold();
    private static final int PREFETCH_EVENT_LOCAL_COUNT_THRESHOLD = SubscriptionConfig.getInstance().getSubscriptionPrefetchEventLocalCountThreshold();
    private static final int PREFETCH_EVENT_GLOBAL_COUNT_THRESHOLD = SubscriptionConfig.getInstance().getSubscriptionPrefetchEventGlobalCountThreshold();
    private final SubscriptionPrefetchingQueue prefetchingQueue;
    private volatile long lastPollRequestTimestamp;
    private final Meter pollRequestMeter;
    private final Meter missingPrefechMeter;
    private final Counter disorderCauseCounter;

    public SubscriptionPrefetchingQueueStates(SubscriptionPrefetchingQueue prefetchingQueue) {
        this.prefetchingQueue = prefetchingQueue;
        this.lastPollRequestTimestamp = -1L;
        this.pollRequestMeter = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
        this.missingPrefechMeter = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
        this.disorderCauseCounter = new Counter();
    }

    public void markPollRequest() {
        this.lastPollRequestTimestamp = System.currentTimeMillis();
        this.pollRequestMeter.mark();
    }

    public void markMissingPrefetch() {
        this.missingPrefechMeter.mark();
    }

    public void markDisorderCause() {
        this.disorderCauseCounter.inc();
    }

    private double pollRate() {
        return this.pollRequestMeter.getOneMinuteRate();
    }

    private double missingRate() {
        if (SubscriptionPrefetchingQueueStates.isApproximatelyZero(this.pollRate())) {
            return 0.0;
        }
        return this.missingPrefechMeter.getOneMinuteRate() / this.pollRate();
    }

    public boolean shouldPrefetch() {
        if (!SubscriptionConfig.getInstance().getSubscriptionPrefetchEnabled()) {
            return false;
        }
        if (!this.isMemoryEnough()) {
            return false;
        }
        if (this.hasTooManyPrefetchedLocalEvent()) {
            return false;
        }
        if (this.hasTooManyPrefetchedGlobalEvent()) {
            return false;
        }
        if (this.hasDisorderCause()) {
            return false;
        }
        if (this.isMissingRateTooHigh()) {
            return true;
        }
        return (double)(System.currentTimeMillis() - this.lastPollRequestTimestamp) * this.pollRate() > 1000.0;
    }

    private boolean isMemoryEnough() {
        return (double)PipeDataNodeResourceManager.memory().getTotalNonFloatingMemorySizeInBytes() * PREFETCH_MEMORY_THRESHOLD > (double)PipeDataNodeResourceManager.memory().getUsedMemorySizeInBytes();
    }

    private boolean hasTooManyPrefetchedLocalEvent() {
        return this.prefetchingQueue.getPrefetchedEventCount() > PREFETCH_EVENT_LOCAL_COUNT_THRESHOLD;
    }

    private boolean hasTooManyPrefetchedGlobalEvent() {
        return this.prefetchingQueue.getPrefetchedEventCount() * SubscriptionAgent.broker().getPrefetchingQueueCount() > PREFETCH_EVENT_GLOBAL_COUNT_THRESHOLD;
    }

    private boolean isMissingRateTooHigh() {
        return this.missingRate() > PREFETCH_MISSING_RATE_THRESHOLD;
    }

    private boolean hasDisorderCause() {
        return this.disorderCauseCounter.getCount() > 0L;
    }

    private static boolean isApproximatelyZero(double value) {
        return Math.abs(value) < 1.0E-6;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lastPollRequestTimestamp", this.lastPollRequestTimestamp).add("pollRate", this.pollRate()).add("missingRate", this.missingRate()).add("disorderCause", this.disorderCauseCounter.getCount()).toString();
    }
}

