/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.FunctionType;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum UDFType {
    TREE_AVAILABLE(Model.TREE, FunctionType.NONE, Available.AVAILABLE),
    TREE_UNAVAILABLE(Model.TREE, FunctionType.NONE, Available.UNAVAILABLE),
    TABLE_AVAILABLE_SCALAR(Model.TABLE, FunctionType.SCALAR, Available.AVAILABLE),
    TABLE_AVAILABLE_AGGREGATE(Model.TABLE, FunctionType.AGGREGATE, Available.AVAILABLE),
    TABLE_AVAILABLE_TABLE(Model.TABLE, FunctionType.TABLE, Available.AVAILABLE),
    TABLE_UNAVAILABLE_SCALAR(Model.TABLE, FunctionType.SCALAR, Available.UNAVAILABLE),
    TABLE_UNAVAILABLE_AGGREGATE(Model.TABLE, FunctionType.AGGREGATE, Available.UNAVAILABLE),
    TABLE_UNAVAILABLE_TABLE(Model.TABLE, FunctionType.TABLE, Available.UNAVAILABLE);

    private static final int MODEL_SHIFT = 7;
    private static final int TYPE_SHIFT = 2;
    private static final int AVAILABLE_SHIFT = 1;
    private static final byte MODEL_MASK = -128;
    private static final byte TYPE_MASK = 124;
    private static final byte AVAILABLE_MASK = 2;
    private final Model model;
    private final FunctionType type;
    private final Available available;

    private UDFType(Model model, FunctionType type, Available available) {
        this.model = model;
        this.type = type;
        this.available = available;
    }

    public static UDFType of(Model model, FunctionType type, boolean available) {
        if (model == Model.TREE) {
            return available ? TREE_AVAILABLE : TREE_UNAVAILABLE;
        }
        switch (type) {
            case SCALAR: {
                return available ? TABLE_AVAILABLE_SCALAR : TABLE_UNAVAILABLE_SCALAR;
            }
            case AGGREGATE: {
                return available ? TABLE_AVAILABLE_AGGREGATE : TABLE_UNAVAILABLE_AGGREGATE;
            }
            case TABLE: {
                return available ? TABLE_AVAILABLE_TABLE : TABLE_UNAVAILABLE_TABLE;
            }
        }
        throw new IllegalArgumentException("Unknown FunctionType: " + type);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        byte value = 0;
        value = (byte)(value | (byte)(this.model.getValue() << 7));
        value = (byte)(value | (byte)(this.type.getValue() << 2));
        value = (byte)(value | (byte)(this.available.getValue() << 1));
        stream.writeByte(value);
    }

    public static UDFType deserialize(ByteBuffer buffer) {
        byte readByte = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        for (UDFType udfType : UDFType.values()) {
            if ((byte)(udfType.model.getValue() << 7) != (readByte & 0xFFFFFF80) || (byte)(udfType.type.getValue() << 2) != (readByte & 0x7C) || (byte)(udfType.available.getValue() << 1) != (readByte & 2)) continue;
            return udfType;
        }
        throw new IllegalArgumentException("Unknown UDFType:" + String.format("%8s", Integer.toBinaryString(readByte & 0xFF)).replace(' ', '0'));
    }

    public boolean isTreeModel() {
        return this.model == Model.TREE;
    }

    public boolean isTableModel() {
        return this.model == Model.TABLE;
    }

    public boolean isAvailable() {
        return this.available == Available.AVAILABLE;
    }

    public FunctionType getType() {
        return this.type;
    }

    public UDFType setAvailable(boolean available) {
        if (this.isTreeModel()) {
            return available ? TREE_AVAILABLE : TREE_UNAVAILABLE;
        }
        switch (this.type) {
            case SCALAR: {
                return available ? TABLE_AVAILABLE_SCALAR : TABLE_UNAVAILABLE_SCALAR;
            }
            case AGGREGATE: {
                return available ? TABLE_AVAILABLE_AGGREGATE : TABLE_UNAVAILABLE_AGGREGATE;
            }
            case TABLE: {
                return available ? TABLE_AVAILABLE_TABLE : TABLE_UNAVAILABLE_TABLE;
            }
        }
        throw new IllegalArgumentException("Unknown FunctionType: " + this.type);
    }

    private static enum Available {
        AVAILABLE(0),
        UNAVAILABLE(1);

        private final byte value;

        private Available(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

