/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BigArrays;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class DoubleBigArray {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DoubleBigArray.class);
    private static final long SIZE_OF_SEGMENT = RamUsageEstimator.sizeOfDoubleArray((int)1024);
    private final double initialValue;
    private double[][] array;
    private long capacity;
    private int segments;

    public DoubleBigArray() {
        this(0.0);
    }

    public DoubleBigArray(double initialValue) {
        this.initialValue = initialValue;
        this.array = new double[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public double get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, double value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void add(long index, double value) {
        double[] dArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        dArray[n] = dArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    public void fill(double value) {
        for (double[] segment : this.array) {
            if (segment == null) {
                return;
            }
            Arrays.fill(segment, value);
        }
    }

    public void reset() {
        this.fill(this.initialValue);
    }

    public void copyTo(long sourceIndex, DoubleBigArray destination, long destinationIndex, long length) {
        while (length > 0L) {
            int startSegment = BigArrays.segment(sourceIndex);
            int startOffset = BigArrays.offset(sourceIndex);
            int destinationStartSegment = BigArrays.segment(destinationIndex);
            int destinationStartOffset = BigArrays.offset(destinationIndex);
            int copyLength = Math.min(1024 - startOffset, 1024 - destinationStartOffset);
            copyLength = Math.min(copyLength, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length);
            System.arraycopy(this.array[startSegment], startOffset, destination.array[destinationStartSegment], destinationStartOffset, copyLength);
            sourceIndex += (long)copyLength;
            destinationIndex += (long)copyLength;
            length -= (long)copyLength;
        }
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (double[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        double[] newSegment = new double[1024];
        if (this.initialValue != 0.0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

