/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoutes;
import org.reactivestreams.Publisher;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class JMAPRoute {
    private final Endpoint endpoint;
    private final Action action;

    public static Builder.RequireEndpoint builder() {
        return endpoint -> action -> new Builder.ReadyToBuild(endpoint, action);
    }

    private JMAPRoute(Endpoint endpoint, Action action) {
        this.endpoint = endpoint;
        this.action = action;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean matches(HttpServerRequest request) {
        return this.endpoint.matches(request);
    }

    public static class Builder {

        public static class ReadyToBuild {
            private final Endpoint endpoint;
            private final Action action;

            ReadyToBuild(Endpoint endpoint, Action action) {
                this.endpoint = endpoint;
                this.action = action;
            }

            public JMAPRoute corsHeaders() {
                return this.build(JMAPRoutes.corsHeaders(this.action));
            }

            public JMAPRoute noCorsHeaders() {
                return this.build(this.action);
            }

            private JMAPRoute build(Action action) {
                return new JMAPRoute(this.endpoint, this.actionWithParameterResolving(action));
            }

            Action actionWithParameterResolving(Action action) {
                return (req, res) -> action.handleRequest(req.paramsResolver(s -> this.endpoint.getUriPathTemplate().match((String)s)), res);
            }
        }

        @FunctionalInterface
        public static interface RequireAction {
            public ReadyToBuild action(Action var1);
        }

        @FunctionalInterface
        public static interface RequireEndpoint {
            public RequireAction endpoint(Endpoint var1);
        }
    }

    public static interface Action {
        public Publisher<Void> handleRequest(HttpServerRequest var1, HttpServerResponse var2);
    }
}

