/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.Properties;

public class PropertyBuilder {
    private static final int INITIAL_CAPACITY = 32;
    private Long textualLineCount = null;
    private final List<Property> properties;

    public PropertyBuilder(List<Property> props) {
        this.properties = new ArrayList<Property>(props.size());
        for (Property property : props) {
            this.properties.add(new Property(property));
        }
    }

    public PropertyBuilder() {
        this.properties = new ArrayList<Property>(32);
    }

    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    public void setTextualLineCount(Long textualLineCount) {
        this.textualLineCount = textualLineCount;
    }

    private void setProperty(String namespace, String localName, String value) {
        this.properties.removeIf(property -> property.isNamed(namespace, localName));
        if (value != null) {
            this.properties.add(new Property(namespace, localName, value));
        }
    }

    private void setProperty(String namespace, String localName, List<String> values) {
        this.properties.removeIf(property -> property.isNamed(namespace, localName));
        if (values != null) {
            for (String value : values) {
                this.properties.add(new Property(namespace, localName, value));
            }
        }
    }

    private void setProperties(String namespace, Map<String, String> valuesByLocalName) {
        this.properties.removeIf(property -> property.isInSpace(namespace));
        for (Map.Entry<String, String> valueByLocalName : valuesByLocalName.entrySet()) {
            this.properties.add(new Property(namespace, valueByLocalName.getKey().toLowerCase(Locale.US), valueByLocalName.getValue()));
        }
    }

    public void setMediaType(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type", "type", value);
    }

    public void setSubType(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type", "subtype", value);
    }

    public void setContentID(String value) {
        this.setProperty("http://james.apache.org/rfc2045", "Content-ID", value);
    }

    public void setContentDescription(String value) {
        this.setProperty("http://james.apache.org/rfc2045", "Content-Description", value);
    }

    public void setContentTransferEncoding(String value) {
        this.setProperty("http://james.apache.org/rfc2045", "Content-Transfer-Encoding", value);
    }

    public void setContentLocation(String value) {
        this.setProperty("http://james.apache.org/rfc2557", "Content-Location", value);
    }

    public void setContentDispositionType(String value) {
        this.setProperty("http://james.apache.org/rfc2183Content-Disposition", "disposition-type", value);
    }

    public void setContentDispositionParameters(Map<String, String> valuesByParameterName) {
        this.setProperties("http://james.apache.org/rfc2183Content-Disposition/params", valuesByParameterName);
    }

    public void setContentTypeParameters(Map<String, String> valuesByParameterName) {
        this.setProperties("http://james.apache.org/rfc2045/Content-Type/params", valuesByParameterName);
    }

    public void setContentMD5(String value) {
        this.setProperty("http://james.apache.org/rfc1864", "Content-MD5", value);
    }

    public void setCharset(String value) {
        this.setProperty("http://james.apache.org/rfc2045/Content-Type/params", "charset", value);
    }

    public void setContentLanguage(List<String> values) {
        this.setProperty("http://james.apache.org/rfc1766", "Content-Language", values);
    }

    public List<Property> toProperties() {
        return new ArrayList<Property>(this.properties);
    }

    public Properties build() {
        return new Properties(this.properties, this.textualLineCount);
    }

    public String toString() {
        return "PropertyBuilder (  textualLineCount = " + this.textualLineCount + " properties = " + this.properties + " )";
    }
}

