/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JMeterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final long serialVersionUID = 252L;
    private static final Logger log = LoggerFactory.getLogger(AsynchSampleSender.class);
    private static final transient SampleEvent FINAL_EVENT = new SampleEvent();
    private static final int DEFAULT_QUEUE_SIZE = 100;
    private static final int SERVER_CONFIGURED_CAPACITY = JMeterUtils.getPropDefault("asynch.batch.queue.size", 100);
    private final int clientConfiguredCapacity = JMeterUtils.getPropDefault("asynch.batch.queue.size", 100);
    private final RemoteSampleListener listener;
    private transient BlockingQueue<SampleEvent> queue;
    private transient long queueWaits;
    private transient long queueWaitTime;

    @Deprecated
    public AsynchSampleSender() {
        this(null);
        log.warn("Constructor only intended for use in testing");
    }

    protected AsynchSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        if (log.isInfoEnabled()) {
            log.info("Using Asynch Remote Sampler for this test run, queue size: {}", (Object)this.getCapacity());
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        int capacity = this.getCapacity();
        log.info("Using batch queue size (asynch.batch.queue.size): {}", (Object)capacity);
        this.queue = new ArrayBlockingQueue<SampleEvent>(capacity);
        Worker worker = new Worker(this.queue, this.listener);
        worker.setDaemon(true);
        worker.start();
        return this;
    }

    private int getCapacity() {
        return this.isClientConfigured() ? this.clientConfiguredCapacity : SERVER_CONFIGURED_CAPACITY;
    }

    @Override
    public void testEnded(String host) {
        log.debug("Test Ended on {}", (Object)host);
        try {
            this.listener.testEnded(host);
            this.queue.put(FINAL_EVENT);
        }
        catch (Exception ex) {
            log.warn("testEnded(host)", (Throwable)ex);
        }
        if (this.queueWaits > 0L) {
            log.info("QueueWaits: {}; QueueWaitTime: {} (nanoseconds)", (Object)this.queueWaits, (Object)this.queueWaitTime);
        }
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        try {
            if (!this.queue.offer(e)) {
                ++this.queueWaits;
                long t1 = System.nanoTime();
                this.queue.put(e);
                long t2 = System.nanoTime();
                this.queueWaitTime += t2 - t1;
            }
        }
        catch (Exception err) {
            log.error("sampleOccurred; failed to queue the sample", (Throwable)err);
        }
    }

    private static class Worker
    extends Thread {
        private final BlockingQueue<? extends SampleEvent> queue;
        private final RemoteSampleListener listener;

        private Worker(BlockingQueue<? extends SampleEvent> q, RemoteSampleListener l) {
            this.queue = q;
            this.listener = l;
        }

        @Override
        public void run() {
            try {
                boolean eof = false;
                while (!eof) {
                    ArrayList<SampleEvent> l = new ArrayList<SampleEvent>();
                    SampleEvent e = this.queue.take();
                    while (!(eof = e == FINAL_EVENT) && e != null) {
                        l.add(e);
                        e = (SampleEvent)this.queue.poll();
                    }
                    int size = l.size();
                    if (size <= 0) continue;
                    try {
                        this.listener.processBatch(l);
                    }
                    catch (RemoteException err) {
                        if (err.getCause() instanceof ConnectException) {
                            throw new JMeterError("Could not return sample", (Throwable)err);
                        }
                        log.error("Failed to return sample", (Throwable)err);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.debug("Worker ended");
        }
    }
}

