/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledTextArea
extends JPanel
implements JLabeledField,
FocusListener {
    private static final long serialVersionUID = 240L;
    private final JLabel mLabel;
    private final JTextArea mTextArea;
    private final ArrayList<ChangeListener> mChangeListeners = new ArrayList(3);
    private String oldValue = "";

    public JLabeledTextArea() {
        this("", null);
    }

    public JLabeledTextArea(String label) {
        this(label, null);
    }

    public JLabeledTextArea(String pLabel, Document docModel) {
        this.mTextArea = new JTextArea();
        this.mLabel = new JLabel(pLabel);
        this.init();
        if (docModel != null) {
            this.mTextArea.setDocument(docModel);
        }
    }

    @Override
    public List<JComponent> getComponentList() {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.mTextArea);
        return comps;
    }

    public void setDocumentModel(Document docModel) {
        this.mTextArea.setDocument(docModel);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.mTextArea.setRows(4);
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.addFocusListener(this);
        this.add((Component)this.mLabel, "North");
        this.add((Component)new JScrollPane(this.mTextArea), "Center");
    }

    @Override
    public void focusLost(FocusEvent pFocusEvent) {
        if (!this.oldValue.equals(this.mTextArea.getText())) {
            this.notifyChangeListeners();
        }
    }

    @Override
    public void focusGained(FocusEvent pFocusEvent) {
        this.oldValue = this.mTextArea.getText();
    }

    @Override
    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    @Override
    public void setText(String pText) {
        this.mTextArea.setText(pText);
    }

    @Override
    public String getText() {
        return this.mTextArea.getText();
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.mTextArea.setEnabled(enable);
    }

    @Override
    public void setToolTipText(String text) {
        this.mTextArea.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.mTextArea.getToolTipText();
    }

    @Override
    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener mChangeListener : this.mChangeListeners) {
            mChangeListener.stateChanged(ce);
        }
    }

    public String[] getTextLines() {
        int numLines = this.mTextArea.getLineCount();
        String[] lines = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            try {
                int start = this.mTextArea.getLineStartOffset(i);
                int end = this.mTextArea.getLineEndOffset(i);
                if (i == numLines - 1) {
                    ++end;
                }
                lines[i] = this.mTextArea.getText(start, end - start - 1);
                continue;
            }
            catch (BadLocationException e) {
                throw new IllegalStateException("Could not read line " + i, e);
            }
        }
        return lines;
    }
}

